package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDBNodesParameters invokes the polardb.DescribeDBNodesParameters API synchronously
func (client *Client) DescribeDBNodesParameters(request *DescribeDBNodesParametersRequest) (response *DescribeDBNodesParametersResponse, err error) {
	response = CreateDescribeDBNodesParametersResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDBNodesParametersWithChan invokes the polardb.DescribeDBNodesParameters API asynchronously
func (client *Client) DescribeDBNodesParametersWithChan(request *DescribeDBNodesParametersRequest) (<-chan *DescribeDBNodesParametersResponse, <-chan error) {
	responseChan := make(chan *DescribeDBNodesParametersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDBNodesParameters(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDBNodesParametersWithCallback invokes the polardb.DescribeDBNodesParameters API asynchronously
func (client *Client) DescribeDBNodesParametersWithCallback(request *DescribeDBNodesParametersRequest, callback func(response *DescribeDBNodesParametersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDBNodesParametersResponse
		var err error
		defer close(result)
		response, err = client.DescribeDBNodesParameters(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDBNodesParametersRequest is the request struct for api DescribeDBNodesParameters
type DescribeDBNodesParametersRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DBNodeIds            string           `position:"Query" name:"DBNodeIds"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeDBNodesParametersResponse is the response struct for api DescribeDBNodesParameters
type DescribeDBNodesParametersResponse struct {
	*responses.BaseResponse
	DBVersion string            `json:"DBVersion" xml:"DBVersion"`
	RequestId string            `json:"RequestId" xml:"RequestId"`
	DBType    string            `json:"DBType" xml:"DBType"`
	Engine    string            `json:"Engine" xml:"Engine"`
	DBNodeIds []DBNodeParameter `json:"DBNodeIds" xml:"DBNodeIds"`
}

// CreateDescribeDBNodesParametersRequest creates a request to invoke DescribeDBNodesParameters API
func CreateDescribeDBNodesParametersRequest() (request *DescribeDBNodesParametersRequest) {
	request = &DescribeDBNodesParametersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "DescribeDBNodesParameters", "polardb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDBNodesParametersResponse creates a response to parse from DescribeDBNodesParameters response
func CreateDescribeDBNodesParametersResponse() (response *DescribeDBNodesParametersResponse) {
	response = &DescribeDBNodesParametersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
