package qianzhou

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryNodeInfo invokes the qianzhou.QueryNodeInfo API synchronously
func (client *Client) QueryNodeInfo(request *QueryNodeInfoRequest) (response *QueryNodeInfoResponse, err error) {
	response = CreateQueryNodeInfoResponse()
	err = client.DoAction(request, response)
	return
}

// QueryNodeInfoWithChan invokes the qianzhou.QueryNodeInfo API asynchronously
func (client *Client) QueryNodeInfoWithChan(request *QueryNodeInfoRequest) (<-chan *QueryNodeInfoResponse, <-chan error) {
	responseChan := make(chan *QueryNodeInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryNodeInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryNodeInfoWithCallback invokes the qianzhou.QueryNodeInfo API asynchronously
func (client *Client) QueryNodeInfoWithCallback(request *QueryNodeInfoRequest, callback func(response *QueryNodeInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryNodeInfoResponse
		var err error
		defer close(result)
		response, err = client.QueryNodeInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryNodeInfoRequest is the request struct for api QueryNodeInfo
type QueryNodeInfoRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Query" name:"instanceId"`
}

// QueryNodeInfoResponse is the response struct for api QueryNodeInfo
type QueryNodeInfoResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"requestId" xml:"requestId"`
	Code      int        `json:"code" xml:"code"`
	Msg       string     `json:"msg" xml:"msg"`
	Data      []DataItem `json:"data" xml:"data"`
}

// CreateQueryNodeInfoRequest creates a request to invoke QueryNodeInfo API
func CreateQueryNodeInfoRequest() (request *QueryNodeInfoRequest) {
	request = &QueryNodeInfoRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("qianzhou", "2021-11-11", "QueryNodeInfo", "/popapi/queryByInstanceId", "", "")
	request.Method = requests.GET
	return
}

// CreateQueryNodeInfoResponse creates a response to parse from QueryNodeInfo response
func CreateQueryNodeInfoResponse() (response *QueryNodeInfoResponse) {
	response = &QueryNodeInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
