package quotas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetProductQuota invokes the quotas.GetProductQuota API synchronously
func (client *Client) GetProductQuota(request *GetProductQuotaRequest) (response *GetProductQuotaResponse, err error) {
	response = CreateGetProductQuotaResponse()
	err = client.DoAction(request, response)
	return
}

// GetProductQuotaWithChan invokes the quotas.GetProductQuota API asynchronously
func (client *Client) GetProductQuotaWithChan(request *GetProductQuotaRequest) (<-chan *GetProductQuotaResponse, <-chan error) {
	responseChan := make(chan *GetProductQuotaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetProductQuota(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetProductQuotaWithCallback invokes the quotas.GetProductQuota API asynchronously
func (client *Client) GetProductQuotaWithCallback(request *GetProductQuotaRequest, callback func(response *GetProductQuotaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetProductQuotaResponse
		var err error
		defer close(result)
		response, err = client.GetProductQuota(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetProductQuotaRequest is the request struct for api GetProductQuota
type GetProductQuotaRequest struct {
	*requests.RpcRequest
	ProductCode     string                       `position:"Body" name:"ProductCode"`
	QuotaActionCode string                       `position:"Body" name:"QuotaActionCode"`
	OriginalContext string                       `position:"Body" name:"OriginalContext"`
	Dimensions      *[]GetProductQuotaDimensions `position:"Body" name:"Dimensions"  type:"Repeated"`
}

// GetProductQuotaDimensions is a repeated param struct in GetProductQuotaRequest
type GetProductQuotaDimensions struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// GetProductQuotaResponse is the response struct for api GetProductQuota
type GetProductQuotaResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Quota     Quota  `json:"Quota" xml:"Quota"`
}

// CreateGetProductQuotaRequest creates a request to invoke GetProductQuota API
func CreateGetProductQuotaRequest() (request *GetProductQuotaRequest) {
	request = &GetProductQuotaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quotas", "2020-05-10", "GetProductQuota", "quotas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetProductQuotaResponse creates a response to parse from GetProductQuota response
func CreateGetProductQuotaResponse() (response *GetProductQuotaResponse) {
	response = &GetProductQuotaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
