package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDBMiniEngineVersions invokes the rds.DescribeDBMiniEngineVersions API synchronously
func (client *Client) DescribeDBMiniEngineVersions(request *DescribeDBMiniEngineVersionsRequest) (response *DescribeDBMiniEngineVersionsResponse, err error) {
	response = CreateDescribeDBMiniEngineVersionsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDBMiniEngineVersionsWithChan invokes the rds.DescribeDBMiniEngineVersions API asynchronously
func (client *Client) DescribeDBMiniEngineVersionsWithChan(request *DescribeDBMiniEngineVersionsRequest) (<-chan *DescribeDBMiniEngineVersionsResponse, <-chan error) {
	responseChan := make(chan *DescribeDBMiniEngineVersionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDBMiniEngineVersions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDBMiniEngineVersionsWithCallback invokes the rds.DescribeDBMiniEngineVersions API asynchronously
func (client *Client) DescribeDBMiniEngineVersionsWithCallback(request *DescribeDBMiniEngineVersionsRequest, callback func(response *DescribeDBMiniEngineVersionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDBMiniEngineVersionsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDBMiniEngineVersions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDBMiniEngineVersionsRequest is the request struct for api DescribeDBMiniEngineVersions
type DescribeDBMiniEngineVersionsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	NodeType             string           `position:"Query" name:"NodeType"`
	EngineVersion        string           `position:"Query" name:"EngineVersion"`
	StorageType          string           `position:"Query" name:"StorageType"`
	MinorVersionTag      string           `position:"Query" name:"MinorVersionTag"`
	Engine               string           `position:"Query" name:"Engine"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
	DedicatedHostGroupId string           `position:"Query" name:"DedicatedHostGroupId"`
}

// DescribeDBMiniEngineVersionsResponse is the response struct for api DescribeDBMiniEngineVersions
type DescribeDBMiniEngineVersionsResponse struct {
	*responses.BaseResponse
	DBInstanceId      string                  `json:"DBInstanceId" xml:"DBInstanceId"`
	RequestId         string                  `json:"RequestId" xml:"RequestId"`
	TotalCount        int                     `json:"TotalCount" xml:"TotalCount"`
	PageNumbers       int                     `json:"PageNumbers" xml:"PageNumbers"`
	MaxRecordsPerPage int                     `json:"MaxRecordsPerPage" xml:"MaxRecordsPerPage"`
	MinorVersionItems []MinorVersionItemsItem `json:"MinorVersionItems" xml:"MinorVersionItems"`
}

// CreateDescribeDBMiniEngineVersionsRequest creates a request to invoke DescribeDBMiniEngineVersions API
func CreateDescribeDBMiniEngineVersionsRequest() (request *DescribeDBMiniEngineVersionsRequest) {
	request = &DescribeDBMiniEngineVersionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "DescribeDBMiniEngineVersions", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDBMiniEngineVersionsResponse creates a response to parse from DescribeDBMiniEngineVersions response
func CreateDescribeDBMiniEngineVersionsResponse() (response *DescribeDBMiniEngineVersionsResponse) {
	response = &DescribeDBMiniEngineVersionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
