package resourcemanager

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RetryChangeAccountEmail invokes the resourcemanager.RetryChangeAccountEmail API synchronously
func (client *Client) RetryChangeAccountEmail(request *RetryChangeAccountEmailRequest) (response *RetryChangeAccountEmailResponse, err error) {
	response = CreateRetryChangeAccountEmailResponse()
	err = client.DoAction(request, response)
	return
}

// RetryChangeAccountEmailWithChan invokes the resourcemanager.RetryChangeAccountEmail API asynchronously
func (client *Client) RetryChangeAccountEmailWithChan(request *RetryChangeAccountEmailRequest) (<-chan *RetryChangeAccountEmailResponse, <-chan error) {
	responseChan := make(chan *RetryChangeAccountEmailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RetryChangeAccountEmail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RetryChangeAccountEmailWithCallback invokes the resourcemanager.RetryChangeAccountEmail API asynchronously
func (client *Client) RetryChangeAccountEmailWithCallback(request *RetryChangeAccountEmailRequest, callback func(response *RetryChangeAccountEmailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RetryChangeAccountEmailResponse
		var err error
		defer close(result)
		response, err = client.RetryChangeAccountEmail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RetryChangeAccountEmailRequest is the request struct for api RetryChangeAccountEmail
type RetryChangeAccountEmailRequest struct {
	*requests.RpcRequest
	AccountId string `position:"Query" name:"AccountId"`
}

// RetryChangeAccountEmailResponse is the response struct for api RetryChangeAccountEmail
type RetryChangeAccountEmailResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRetryChangeAccountEmailRequest creates a request to invoke RetryChangeAccountEmail API
func CreateRetryChangeAccountEmailRequest() (request *RetryChangeAccountEmailRequest) {
	request = &RetryChangeAccountEmailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceManager", "2020-03-31", "RetryChangeAccountEmail", "resourcemanager", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRetryChangeAccountEmailResponse creates a response to parse from RetryChangeAccountEmail response
func CreateRetryChangeAccountEmailResponse() (response *RetryChangeAccountEmailResponse) {
	response = &RetryChangeAccountEmailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
