package safe

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SafeChangeCancel invokes the safe.SafeChangeCancel API synchronously
func (client *Client) SafeChangeCancel(request *SafeChangeCancelRequest) (response *SafeChangeCancelResponse, err error) {
	response = CreateSafeChangeCancelResponse()
	err = client.DoAction(request, response)
	return
}

// SafeChangeCancelWithChan invokes the safe.SafeChangeCancel API asynchronously
func (client *Client) SafeChangeCancelWithChan(request *SafeChangeCancelRequest) (<-chan *SafeChangeCancelResponse, <-chan error) {
	responseChan := make(chan *SafeChangeCancelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SafeChangeCancel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SafeChangeCancelWithCallback invokes the safe.SafeChangeCancel API asynchronously
func (client *Client) SafeChangeCancelWithCallback(request *SafeChangeCancelRequest, callback func(response *SafeChangeCancelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SafeChangeCancelResponse
		var err error
		defer close(result)
		response, err = client.SafeChangeCancel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SafeChangeCancelRequest is the request struct for api SafeChangeCancel
type SafeChangeCancelRequest struct {
	*requests.RpcRequest
	AuthKey       string           `position:"Body" name:"AuthKey"`
	ReqTimestamp  requests.Integer `position:"Body" name:"ReqTimestamp"`
	SourceOrderId string           `position:"Body" name:"SourceOrderId"`
	AuthSign      string           `position:"Body" name:"AuthSign"`
	OperateEmpNo  string           `position:"Body" name:"OperateEmpNo"`
}

// SafeChangeCancelResponse is the response struct for api SafeChangeCancel
type SafeChangeCancelResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSafeChangeCancelRequest creates a request to invoke SafeChangeCancel API
func CreateSafeChangeCancelRequest() (request *SafeChangeCancelRequest) {
	request = &SafeChangeCancelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Safe", "2022-01-17", "SafeChangeCancel", "", "")
	request.Method = requests.POST
	return
}

// CreateSafeChangeCancelResponse creates a response to parse from SafeChangeCancel response
func CreateSafeChangeCancelResponse() (response *SafeChangeCancelResponse) {
	response = &SafeChangeCancelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
