package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateStorageBundle invokes the sgw.CreateStorageBundle API synchronously
func (client *Client) CreateStorageBundle(request *CreateStorageBundleRequest) (response *CreateStorageBundleResponse, err error) {
	response = CreateCreateStorageBundleResponse()
	err = client.DoAction(request, response)
	return
}

// CreateStorageBundleWithChan invokes the sgw.CreateStorageBundle API asynchronously
func (client *Client) CreateStorageBundleWithChan(request *CreateStorageBundleRequest) (<-chan *CreateStorageBundleResponse, <-chan error) {
	responseChan := make(chan *CreateStorageBundleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateStorageBundle(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateStorageBundleWithCallback invokes the sgw.CreateStorageBundle API asynchronously
func (client *Client) CreateStorageBundleWithCallback(request *CreateStorageBundleRequest, callback func(response *CreateStorageBundleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateStorageBundleResponse
		var err error
		defer close(result)
		response, err = client.CreateStorageBundle(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateStorageBundleRequest is the request struct for api CreateStorageBundle
type CreateStorageBundleRequest struct {
	*requests.RpcRequest
	BackendBucketRegionId string `position:"Query" name:"BackendBucketRegionId"`
	Description           string `position:"Query" name:"Description"`
	ResourceGroupId       string `position:"Query" name:"ResourceGroupId"`
	SecurityToken         string `position:"Query" name:"SecurityToken"`
	Name                  string `position:"Query" name:"Name"`
	Location              string `position:"Query" name:"Location"`
}

// CreateStorageBundleResponse is the response struct for api CreateStorageBundle
type CreateStorageBundleResponse struct {
	*responses.BaseResponse
	RequestId       string `json:"RequestId" xml:"RequestId"`
	Success         bool   `json:"Success" xml:"Success"`
	Code            string `json:"Code" xml:"Code"`
	Message         string `json:"Message" xml:"Message"`
	StorageBundleId string `json:"StorageBundleId" xml:"StorageBundleId"`
}

// CreateCreateStorageBundleRequest creates a request to invoke CreateStorageBundle API
func CreateCreateStorageBundleRequest() (request *CreateStorageBundleRequest) {
	request = &CreateStorageBundleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "CreateStorageBundle", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateStorageBundleResponse creates a response to parse from CreateStorageBundle response
func CreateCreateStorageBundleResponse() (response *CreateStorageBundleResponse) {
	response = &CreateStorageBundleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
