package sophonsoar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ComparePlaybooks invokes the sophonsoar.ComparePlaybooks API synchronously
func (client *Client) ComparePlaybooks(request *ComparePlaybooksRequest) (response *ComparePlaybooksResponse, err error) {
	response = CreateComparePlaybooksResponse()
	err = client.DoAction(request, response)
	return
}

// ComparePlaybooksWithChan invokes the sophonsoar.ComparePlaybooks API asynchronously
func (client *Client) ComparePlaybooksWithChan(request *ComparePlaybooksRequest) (<-chan *ComparePlaybooksResponse, <-chan error) {
	responseChan := make(chan *ComparePlaybooksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ComparePlaybooks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ComparePlaybooksWithCallback invokes the sophonsoar.ComparePlaybooks API asynchronously
func (client *Client) ComparePlaybooksWithCallback(request *ComparePlaybooksRequest, callback func(response *ComparePlaybooksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ComparePlaybooksResponse
		var err error
		defer close(result)
		response, err = client.ComparePlaybooks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ComparePlaybooksRequest is the request struct for api ComparePlaybooks
type ComparePlaybooksRequest struct {
	*requests.RpcRequest
	OldPlaybookReleaseId requests.Integer `position:"Query" name:"OldPlaybookReleaseId"`
	NewPlaybookReleaseId requests.Integer `position:"Query" name:"NewPlaybookReleaseId"`
	RoleFor              string           `position:"Query" name:"RoleFor"`
	PlaybookUuid         string           `position:"Query" name:"PlaybookUuid"`
	RoleType             string           `position:"Query" name:"RoleType"`
	Lang                 string           `position:"Query" name:"Lang"`
}

// ComparePlaybooksResponse is the response struct for api ComparePlaybooks
type ComparePlaybooksResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	CompareResult CompareResult `json:"CompareResult" xml:"CompareResult"`
}

// CreateComparePlaybooksRequest creates a request to invoke ComparePlaybooks API
func CreateComparePlaybooksRequest() (request *ComparePlaybooksRequest) {
	request = &ComparePlaybooksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sophonsoar", "2022-07-28", "ComparePlaybooks", "", "")
	request.Method = requests.POST
	return
}

// CreateComparePlaybooksResponse creates a response to parse from ComparePlaybooks response
func CreateComparePlaybooksResponse() (response *ComparePlaybooksResponse) {
	response = &ComparePlaybooksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
