package unimkt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListTenant invokes the unimkt.ListTenant API synchronously
func (client *Client) ListTenant(request *ListTenantRequest) (response *ListTenantResponse, err error) {
	response = CreateListTenantResponse()
	err = client.DoAction(request, response)
	return
}

// ListTenantWithChan invokes the unimkt.ListTenant API asynchronously
func (client *Client) ListTenantWithChan(request *ListTenantRequest) (<-chan *ListTenantResponse, <-chan error) {
	responseChan := make(chan *ListTenantResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTenant(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListTenantWithCallback invokes the unimkt.ListTenant API asynchronously
func (client *Client) ListTenantWithCallback(request *ListTenantRequest, callback func(response *ListTenantResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTenantResponse
		var err error
		defer close(result)
		response, err = client.ListTenant(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListTenantRequest is the request struct for api ListTenant
type ListTenantRequest struct {
	*requests.RpcRequest
	EndCreateTime    requests.Integer `position:"Query" name:"EndCreateTime"`
	Business         string           `position:"Query" name:"Business"`
	UserId           string           `position:"Query" name:"UserId"`
	OriginSiteUserId string           `position:"Query" name:"OriginSiteUserId"`
	PageNumber       requests.Integer `position:"Query" name:"PageNumber"`
	Environment      string           `position:"Query" name:"Environment"`
	AppName          string           `position:"Query" name:"AppName"`
	StartCreateTime  requests.Integer `position:"Query" name:"StartCreateTime"`
	TenantId         string           `position:"Query" name:"TenantId"`
	PageSize         requests.Integer `position:"Query" name:"PageSize"`
	UserSite         string           `position:"Query" name:"UserSite"`
	TenantName       string           `position:"Query" name:"TenantName"`
	Status           string           `position:"Query" name:"Status"`
}

// ListTenantResponse is the response struct for api ListTenant
type ListTenantResponse struct {
	*responses.BaseResponse
	Code       string   `json:"Code" xml:"Code"`
	Success    bool     `json:"Success" xml:"Success"`
	Message    string   `json:"Message" xml:"Message"`
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	PageNumber int      `json:"PageNumber" xml:"PageNumber"`
	PageSize   int      `json:"PageSize" xml:"PageSize"`
	Total      int64    `json:"Total" xml:"Total"`
	Model      []Tenant `json:"Model" xml:"Model"`
}

// CreateListTenantRequest creates a request to invoke ListTenant API
func CreateListTenantRequest() (request *ListTenantRequest) {
	request = &ListTenantRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("UniMkt", "2018-12-12", "ListTenant", "uniMkt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListTenantResponse creates a response to parse from ListTenant response
func CreateListTenantResponse() (response *ListTenantResponse) {
	response = &ListTenantResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
