package viapi_regen

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableDataReflow invokes the viapi_regen.EnableDataReflow API synchronously
func (client *Client) EnableDataReflow(request *EnableDataReflowRequest) (response *EnableDataReflowResponse, err error) {
	response = CreateEnableDataReflowResponse()
	err = client.DoAction(request, response)
	return
}

// EnableDataReflowWithChan invokes the viapi_regen.EnableDataReflow API asynchronously
func (client *Client) EnableDataReflowWithChan(request *EnableDataReflowRequest) (<-chan *EnableDataReflowResponse, <-chan error) {
	responseChan := make(chan *EnableDataReflowResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableDataReflow(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableDataReflowWithCallback invokes the viapi_regen.EnableDataReflow API asynchronously
func (client *Client) EnableDataReflowWithCallback(request *EnableDataReflowRequest, callback func(response *EnableDataReflowResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableDataReflowResponse
		var err error
		defer close(result)
		response, err = client.EnableDataReflow(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableDataReflowRequest is the request struct for api EnableDataReflow
type EnableDataReflowRequest struct {
	*requests.RpcRequest
	DataReflowRate    requests.Integer `position:"Body" name:"DataReflowRate"`
	DataReflowOssPath string           `position:"Body" name:"DataReflowOssPath"`
	ServiceId         requests.Integer `position:"Body" name:"ServiceId"`
}

// EnableDataReflowResponse is the response struct for api EnableDataReflow
type EnableDataReflowResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateEnableDataReflowRequest creates a request to invoke EnableDataReflow API
func CreateEnableDataReflowRequest() (request *EnableDataReflowRequest) {
	request = &EnableDataReflowRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("viapi-regen", "2021-11-19", "EnableDataReflow", "selflearning", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEnableDataReflowResponse creates a response to parse from EnableDataReflow response
func CreateEnableDataReflowResponse() (response *EnableDataReflowResponse) {
	response = &EnableDataReflowResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
