package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeFailoverTestJobs invokes the vpc.DescribeFailoverTestJobs API synchronously
func (client *Client) DescribeFailoverTestJobs(request *DescribeFailoverTestJobsRequest) (response *DescribeFailoverTestJobsResponse, err error) {
	response = CreateDescribeFailoverTestJobsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeFailoverTestJobsWithChan invokes the vpc.DescribeFailoverTestJobs API asynchronously
func (client *Client) DescribeFailoverTestJobsWithChan(request *DescribeFailoverTestJobsRequest) (<-chan *DescribeFailoverTestJobsResponse, <-chan error) {
	responseChan := make(chan *DescribeFailoverTestJobsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeFailoverTestJobs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeFailoverTestJobsWithCallback invokes the vpc.DescribeFailoverTestJobs API asynchronously
func (client *Client) DescribeFailoverTestJobsWithCallback(request *DescribeFailoverTestJobsRequest, callback func(response *DescribeFailoverTestJobsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeFailoverTestJobsResponse
		var err error
		defer close(result)
		response, err = client.DescribeFailoverTestJobs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeFailoverTestJobsRequest is the request struct for api DescribeFailoverTestJobs
type DescribeFailoverTestJobsRequest struct {
	*requests.RpcRequest
	ClientToken          string                            `position:"Query" name:"ClientToken"`
	NextToken            string                            `position:"Query" name:"NextToken"`
	ResourceOwnerAccount string                            `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string                            `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer                  `position:"Query" name:"OwnerId"`
	Filter               *[]DescribeFailoverTestJobsFilter `position:"Query" name:"Filter"  type:"Repeated"`
	MaxResults           requests.Integer                  `position:"Query" name:"MaxResults"`
}

// DescribeFailoverTestJobsFilter is a repeated param struct in DescribeFailoverTestJobsRequest
type DescribeFailoverTestJobsFilter struct {
	Key   string    `name:"Key"`
	Value *[]string `name:"Value" type:"Repeated"`
}

// DescribeFailoverTestJobsResponse is the response struct for api DescribeFailoverTestJobs
type DescribeFailoverTestJobsResponse struct {
	*responses.BaseResponse
	RequestId           string                    `json:"RequestId" xml:"RequestId"`
	NextToken           string                    `json:"NextToken" xml:"NextToken"`
	MaxResults          int                       `json:"MaxResults" xml:"MaxResults"`
	TotalCount          int                       `json:"TotalCount" xml:"TotalCount"`
	Count               int                       `json:"Count" xml:"Count"`
	FailoverTestJobList []FailoverTestJobListItem `json:"FailoverTestJobList" xml:"FailoverTestJobList"`
}

// CreateDescribeFailoverTestJobsRequest creates a request to invoke DescribeFailoverTestJobs API
func CreateDescribeFailoverTestJobsRequest() (request *DescribeFailoverTestJobsRequest) {
	request = &DescribeFailoverTestJobsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DescribeFailoverTestJobs", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeFailoverTestJobsResponse creates a response to parse from DescribeFailoverTestJobs response
func CreateDescribeFailoverTestJobsResponse() (response *DescribeFailoverTestJobsResponse) {
	response = &DescribeFailoverTestJobsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
