package ahas_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateSystemRule invokes the ahas_openapi.CreateSystemRule API synchronously
func (client *Client) CreateSystemRule(request *CreateSystemRuleRequest) (response *CreateSystemRuleResponse, err error) {
	response = CreateCreateSystemRuleResponse()
	err = client.DoAction(request, response)
	return
}

// CreateSystemRuleWithChan invokes the ahas_openapi.CreateSystemRule API asynchronously
func (client *Client) CreateSystemRuleWithChan(request *CreateSystemRuleRequest) (<-chan *CreateSystemRuleResponse, <-chan error) {
	responseChan := make(chan *CreateSystemRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateSystemRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateSystemRuleWithCallback invokes the ahas_openapi.CreateSystemRule API asynchronously
func (client *Client) CreateSystemRuleWithCallback(request *CreateSystemRuleRequest, callback func(response *CreateSystemRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateSystemRuleResponse
		var err error
		defer close(result)
		response, err = client.CreateSystemRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateSystemRuleRequest is the request struct for api CreateSystemRule
type CreateSystemRuleRequest struct {
	*requests.RpcRequest
	MetricType   requests.Integer `position:"Query" name:"MetricType"`
	Threshold    requests.Float   `position:"Query" name:"Threshold"`
	AhasRegionId string           `position:"Query" name:"AhasRegionId"`
	AppName      string           `position:"Query" name:"AppName"`
	Enable       requests.Boolean `position:"Query" name:"Enable"`
	Namespace    string           `position:"Query" name:"Namespace"`
}

// CreateSystemRuleResponse is the response struct for api CreateSystemRule
type CreateSystemRuleResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCreateSystemRuleRequest creates a request to invoke CreateSystemRule API
func CreateCreateSystemRuleRequest() (request *CreateSystemRuleRequest) {
	request = &CreateSystemRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ahas-openapi", "2019-09-01", "CreateSystemRule", "ahas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateSystemRuleResponse creates a response to parse from CreateSystemRule response
func CreateCreateSystemRuleResponse() (response *CreateSystemRuleResponse) {
	response = &CreateSystemRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
