package ahas_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListActiveApps invokes the ahas_openapi.ListActiveApps API synchronously
func (client *Client) ListActiveApps(request *ListActiveAppsRequest) (response *ListActiveAppsResponse, err error) {
	response = CreateListActiveAppsResponse()
	err = client.DoAction(request, response)
	return
}

// ListActiveAppsWithChan invokes the ahas_openapi.ListActiveApps API asynchronously
func (client *Client) ListActiveAppsWithChan(request *ListActiveAppsRequest) (<-chan *ListActiveAppsResponse, <-chan error) {
	responseChan := make(chan *ListActiveAppsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListActiveApps(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListActiveAppsWithCallback invokes the ahas_openapi.ListActiveApps API asynchronously
func (client *Client) ListActiveAppsWithCallback(request *ListActiveAppsRequest, callback func(response *ListActiveAppsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListActiveAppsResponse
		var err error
		defer close(result)
		response, err = client.ListActiveApps(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListActiveAppsRequest is the request struct for api ListActiveApps
type ListActiveAppsRequest struct {
	*requests.RpcRequest
	AppType      requests.Integer `position:"Query" name:"AppType"`
	AhasRegionId string           `position:"Query" name:"AhasRegionId"`
	Namespace    string           `position:"Query" name:"Namespace"`
}

// ListActiveAppsResponse is the response struct for api ListActiveApps
type ListActiveAppsResponse struct {
	*responses.BaseResponse
	Message   string     `json:"Message" xml:"Message"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Code      string     `json:"Code" xml:"Code"`
	Success   bool       `json:"Success" xml:"Success"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateListActiveAppsRequest creates a request to invoke ListActiveApps API
func CreateListActiveAppsRequest() (request *ListActiveAppsRequest) {
	request = &ListActiveAppsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ahas-openapi", "2019-09-01", "ListActiveApps", "ahas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListActiveAppsResponse creates a response to parse from ListActiveApps response
func CreateListActiveAppsResponse() (response *ListActiveAppsResponse) {
	response = &ListActiveAppsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
