package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddPrometheusIntegration invokes the arms.AddPrometheusIntegration API synchronously
func (client *Client) AddPrometheusIntegration(request *AddPrometheusIntegrationRequest) (response *AddPrometheusIntegrationResponse, err error) {
	response = CreateAddPrometheusIntegrationResponse()
	err = client.DoAction(request, response)
	return
}

// AddPrometheusIntegrationWithChan invokes the arms.AddPrometheusIntegration API asynchronously
func (client *Client) AddPrometheusIntegrationWithChan(request *AddPrometheusIntegrationRequest) (<-chan *AddPrometheusIntegrationResponse, <-chan error) {
	responseChan := make(chan *AddPrometheusIntegrationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddPrometheusIntegration(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddPrometheusIntegrationWithCallback invokes the arms.AddPrometheusIntegration API asynchronously
func (client *Client) AddPrometheusIntegrationWithCallback(request *AddPrometheusIntegrationRequest, callback func(response *AddPrometheusIntegrationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddPrometheusIntegrationResponse
		var err error
		defer close(result)
		response, err = client.AddPrometheusIntegration(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddPrometheusIntegrationRequest is the request struct for api AddPrometheusIntegration
type AddPrometheusIntegrationRequest struct {
	*requests.RpcRequest
	IntegrationType string `position:"Query" name:"IntegrationType"`
	Param           string `position:"Query" name:"Param"`
	ClusterId       string `position:"Query" name:"ClusterId"`
}

// AddPrometheusIntegrationResponse is the response struct for api AddPrometheusIntegration
type AddPrometheusIntegrationResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateAddPrometheusIntegrationRequest creates a request to invoke AddPrometheusIntegration API
func CreateAddPrometheusIntegrationRequest() (request *AddPrometheusIntegrationRequest) {
	request = &AddPrometheusIntegrationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "AddPrometheusIntegration", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddPrometheusIntegrationResponse creates a response to parse from AddPrometheusIntegration response
func CreateAddPrometheusIntegrationResponse() (response *AddPrometheusIntegrationResponse) {
	response = &AddPrometheusIntegrationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
