package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAlertEvents invokes the arms.ListAlertEvents API synchronously
func (client *Client) ListAlertEvents(request *ListAlertEventsRequest) (response *ListAlertEventsResponse, err error) {
	response = CreateListAlertEventsResponse()
	err = client.DoAction(request, response)
	return
}

// ListAlertEventsWithChan invokes the arms.ListAlertEvents API asynchronously
func (client *Client) ListAlertEventsWithChan(request *ListAlertEventsRequest) (<-chan *ListAlertEventsResponse, <-chan error) {
	responseChan := make(chan *ListAlertEventsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAlertEvents(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAlertEventsWithCallback invokes the arms.ListAlertEvents API asynchronously
func (client *Client) ListAlertEventsWithCallback(request *ListAlertEventsRequest, callback func(response *ListAlertEventsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAlertEventsResponse
		var err error
		defer close(result)
		response, err = client.ListAlertEvents(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAlertEventsRequest is the request struct for api ListAlertEvents
type ListAlertEventsRequest struct {
	*requests.RpcRequest
	AlertName          string           `position:"Query" name:"AlertName"`
	EndTime            string           `position:"Query" name:"EndTime"`
	StartTime          string           `position:"Query" name:"StartTime"`
	Size               requests.Integer `position:"Query" name:"Size"`
	MatchingConditions string           `position:"Query" name:"MatchingConditions"`
	Page               requests.Integer `position:"Query" name:"Page"`
	Status             string           `position:"Query" name:"Status"`
}

// ListAlertEventsResponse is the response struct for api ListAlertEvents
type ListAlertEventsResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	PageBean  PageBean `json:"PageBean" xml:"PageBean"`
}

// CreateListAlertEventsRequest creates a request to invoke ListAlertEvents API
func CreateListAlertEventsRequest() (request *ListAlertEventsRequest) {
	request = &ListAlertEventsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "ListAlertEvents", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListAlertEventsResponse creates a response to parse from ListAlertEvents response
func CreateListAlertEventsResponse() (response *ListAlertEventsResponse) {
	response = &ListAlertEventsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
