package biz_ipdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryPreMappingIpSegments invokes the biz_ipdb.QueryPreMappingIpSegments API synchronously
func (client *Client) QueryPreMappingIpSegments(request *QueryPreMappingIpSegmentsRequest) (response *QueryPreMappingIpSegmentsResponse, err error) {
	response = CreateQueryPreMappingIpSegmentsResponse()
	err = client.DoAction(request, response)
	return
}

// QueryPreMappingIpSegmentsWithChan invokes the biz_ipdb.QueryPreMappingIpSegments API asynchronously
func (client *Client) QueryPreMappingIpSegmentsWithChan(request *QueryPreMappingIpSegmentsRequest) (<-chan *QueryPreMappingIpSegmentsResponse, <-chan error) {
	responseChan := make(chan *QueryPreMappingIpSegmentsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryPreMappingIpSegments(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryPreMappingIpSegmentsWithCallback invokes the biz_ipdb.QueryPreMappingIpSegments API asynchronously
func (client *Client) QueryPreMappingIpSegmentsWithCallback(request *QueryPreMappingIpSegmentsRequest, callback func(response *QueryPreMappingIpSegmentsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryPreMappingIpSegmentsResponse
		var err error
		defer close(result)
		response, err = client.QueryPreMappingIpSegments(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryPreMappingIpSegmentsRequest is the request struct for api QueryPreMappingIpSegments
type QueryPreMappingIpSegmentsRequest struct {
	*requests.RpcRequest
	Cluster  string           `position:"Query" name:"Cluster"`
	Pod      string           `position:"Query" name:"Pod"`
	SysOwner string           `position:"Query" name:"SysOwner"`
	PageSize requests.Integer `position:"Query" name:"PageSize"`
	Page     requests.Integer `position:"Query" name:"Page"`
	Value    string           `position:"Query" name:"Value"`
	BizLine  string           `position:"Query" name:"BizLine"`
}

// QueryPreMappingIpSegmentsResponse is the response struct for api QueryPreMappingIpSegments
type QueryPreMappingIpSegmentsResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	PageSize     int          `json:"PageSize" xml:"PageSize"`
	TotalCount   int          `json:"TotalCount" xml:"TotalCount"`
	Page         int          `json:"Page" xml:"Page"`
	IpSegmentSet IpSegmentSet `json:"IpSegmentSet" xml:"IpSegmentSet"`
}

// CreateQueryPreMappingIpSegmentsRequest creates a request to invoke QueryPreMappingIpSegments API
func CreateQueryPreMappingIpSegmentsRequest() (request *QueryPreMappingIpSegmentsRequest) {
	request = &QueryPreMappingIpSegmentsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Biz-ipdb", "2016-08-08", "QueryPreMappingIpSegments", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryPreMappingIpSegmentsResponse creates a response to parse from QueryPreMappingIpSegments response
func CreateQueryPreMappingIpSegmentsResponse() (response *QueryPreMappingIpSegmentsResponse) {
	response = &QueryPreMappingIpSegmentsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
