package cas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListCertWarehouse invokes the cas.ListCertWarehouse API synchronously
func (client *Client) ListCertWarehouse(request *ListCertWarehouseRequest) (response *ListCertWarehouseResponse, err error) {
	response = CreateListCertWarehouseResponse()
	err = client.DoAction(request, response)
	return
}

// ListCertWarehouseWithChan invokes the cas.ListCertWarehouse API asynchronously
func (client *Client) ListCertWarehouseWithChan(request *ListCertWarehouseRequest) (<-chan *ListCertWarehouseResponse, <-chan error) {
	responseChan := make(chan *ListCertWarehouseResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListCertWarehouse(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListCertWarehouseWithCallback invokes the cas.ListCertWarehouse API asynchronously
func (client *Client) ListCertWarehouseWithCallback(request *ListCertWarehouseRequest, callback func(response *ListCertWarehouseResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListCertWarehouseResponse
		var err error
		defer close(result)
		response, err = client.ListCertWarehouse(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListCertWarehouseRequest is the request struct for api ListCertWarehouse
type ListCertWarehouseRequest struct {
	*requests.RpcRequest
	ShowSize    requests.Integer `position:"Query" name:"ShowSize"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	Type        string           `position:"Query" name:"Type"`
	InstanceId  string           `position:"Query" name:"InstanceId"`
	SourceIp    string           `position:"Query" name:"SourceIp"`
	Name        string           `position:"Query" name:"Name"`
}

// ListCertWarehouseResponse is the response struct for api ListCertWarehouse
type ListCertWarehouseResponse struct {
	*responses.BaseResponse
	ShowSize          int64           `json:"ShowSize" xml:"ShowSize"`
	CurrentPage       int64           `json:"CurrentPage" xml:"CurrentPage"`
	TotalCount        int64           `json:"TotalCount" xml:"TotalCount"`
	RequestId         string          `json:"RequestId" xml:"RequestId"`
	CertWarehouseList []CertWarehouse `json:"CertWarehouseList" xml:"CertWarehouseList"`
}

// CreateListCertWarehouseRequest creates a request to invoke ListCertWarehouse API
func CreateListCertWarehouseRequest() (request *ListCertWarehouseRequest) {
	request = &ListCertWarehouseRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cas", "2020-04-07", "ListCertWarehouse", "cas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListCertWarehouseResponse creates a response to parse from ListCertWarehouse response
func CreateListCertWarehouseResponse() (response *ListCertWarehouseResponse) {
	response = &ListCertWarehouseResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
