package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SwitchToConference invokes the ccc.SwitchToConference API synchronously
func (client *Client) SwitchToConference(request *SwitchToConferenceRequest) (response *SwitchToConferenceResponse, err error) {
	response = CreateSwitchToConferenceResponse()
	err = client.DoAction(request, response)
	return
}

// SwitchToConferenceWithChan invokes the ccc.SwitchToConference API asynchronously
func (client *Client) SwitchToConferenceWithChan(request *SwitchToConferenceRequest) (<-chan *SwitchToConferenceResponse, <-chan error) {
	responseChan := make(chan *SwitchToConferenceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SwitchToConference(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SwitchToConferenceWithCallback invokes the ccc.SwitchToConference API asynchronously
func (client *Client) SwitchToConferenceWithCallback(request *SwitchToConferenceRequest, callback func(response *SwitchToConferenceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SwitchToConferenceResponse
		var err error
		defer close(result)
		response, err = client.SwitchToConference(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SwitchToConferenceRequest is the request struct for api SwitchToConference
type SwitchToConferenceRequest struct {
	*requests.RpcRequest
	UserId     string `position:"Query" name:"UserId"`
	DeviceId   string `position:"Query" name:"DeviceId"`
	JobId      string `position:"Query" name:"JobId"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// SwitchToConferenceResponse is the response struct for api SwitchToConference
type SwitchToConferenceResponse struct {
	*responses.BaseResponse
	Code           string   `json:"Code" xml:"Code"`
	HttpStatusCode int      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string   `json:"Message" xml:"Message"`
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	Params         []string `json:"Params" xml:"Params"`
	Data           Data     `json:"Data" xml:"Data"`
}

// CreateSwitchToConferenceRequest creates a request to invoke SwitchToConference API
func CreateSwitchToConferenceRequest() (request *SwitchToConferenceRequest) {
	request = &SwitchToConferenceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "SwitchToConference", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSwitchToConferenceResponse creates a response to parse from SwitchToConference response
func CreateSwitchToConferenceResponse() (response *SwitchToConferenceResponse) {
	response = &SwitchToConferenceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
