package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifySurvey invokes the cloudcallcenter.ModifySurvey API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/modifysurvey.html
func (client *Client) ModifySurvey(request *ModifySurveyRequest) (response *ModifySurveyResponse, err error) {
	response = CreateModifySurveyResponse()
	err = client.DoAction(request, response)
	return
}

// ModifySurveyWithChan invokes the cloudcallcenter.ModifySurvey API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/modifysurvey.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifySurveyWithChan(request *ModifySurveyRequest) (<-chan *ModifySurveyResponse, <-chan error) {
	responseChan := make(chan *ModifySurveyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifySurvey(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifySurveyWithCallback invokes the cloudcallcenter.ModifySurvey API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/modifysurvey.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifySurveyWithCallback(request *ModifySurveyRequest, callback func(response *ModifySurveyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifySurveyResponse
		var err error
		defer close(result)
		response, err = client.ModifySurvey(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifySurveyRequest is the request struct for api ModifySurvey
type ModifySurveyRequest struct {
	*requests.RpcRequest
	Role                    string           `position:"Query" name:"Role"`
	Description             string           `position:"Query" name:"Description"`
	FlowJson                string           `position:"Query" name:"FlowJson"`
	GlobalQuestions         string           `position:"Query" name:"GlobalQuestions"`
	Corpora                 string           `position:"Query" name:"Corpora"`
	BeebotId                string           `position:"Query" name:"BeebotId"`
	ScenarioId              string           `position:"Query" name:"ScenarioId"`
	SurveyId                string           `position:"Query" name:"SurveyId"`
	FlowJsonOssKey          string           `position:"Query" name:"FlowJsonOssKey"`
	SpeechOptimizationParam string           `position:"Query" name:"SpeechOptimizationParam"`
	InstanceId              string           `position:"Query" name:"InstanceId"`
	Round                   requests.Integer `position:"Query" name:"Round"`
	Name                    string           `position:"Query" name:"Name"`
	FlowId                  string           `position:"Query" name:"FlowId"`
}

// ModifySurveyResponse is the response struct for api ModifySurvey
type ModifySurveyResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Survey         Survey `json:"Survey" xml:"Survey"`
}

// CreateModifySurveyRequest creates a request to invoke ModifySurvey API
func CreateModifySurveyRequest() (request *ModifySurveyRequest) {
	request = &ModifySurveyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ModifySurvey", "", "")
	request.Method = requests.POST
	return
}

// CreateModifySurveyResponse creates a response to parse from ModifySurvey response
func CreateModifySurveyResponse() (response *ModifySurveyResponse) {
	response = &ModifySurveyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
