package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchCreateIntantSiteMonitor invokes the cms.BatchCreateIntantSiteMonitor API synchronously
func (client *Client) BatchCreateIntantSiteMonitor(request *BatchCreateIntantSiteMonitorRequest) (response *BatchCreateIntantSiteMonitorResponse, err error) {
	response = CreateBatchCreateIntantSiteMonitorResponse()
	err = client.DoAction(request, response)
	return
}

// BatchCreateIntantSiteMonitorWithChan invokes the cms.BatchCreateIntantSiteMonitor API asynchronously
func (client *Client) BatchCreateIntantSiteMonitorWithChan(request *BatchCreateIntantSiteMonitorRequest) (<-chan *BatchCreateIntantSiteMonitorResponse, <-chan error) {
	responseChan := make(chan *BatchCreateIntantSiteMonitorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchCreateIntantSiteMonitor(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchCreateIntantSiteMonitorWithCallback invokes the cms.BatchCreateIntantSiteMonitor API asynchronously
func (client *Client) BatchCreateIntantSiteMonitorWithCallback(request *BatchCreateIntantSiteMonitorRequest, callback func(response *BatchCreateIntantSiteMonitorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchCreateIntantSiteMonitorResponse
		var err error
		defer close(result)
		response, err = client.BatchCreateIntantSiteMonitor(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchCreateIntantSiteMonitorRequest is the request struct for api BatchCreateIntantSiteMonitor
type BatchCreateIntantSiteMonitorRequest struct {
	*requests.RpcRequest
	TaskList *[]BatchCreateIntantSiteMonitorTaskList `position:"Query" name:"TaskList"  type:"Repeated"`
}

// BatchCreateIntantSiteMonitorTaskList is a repeated param struct in BatchCreateIntantSiteMonitorRequest
type BatchCreateIntantSiteMonitorTaskList struct {
	OptionsJson string `name:"OptionsJson"`
	Address     string `name:"Address"`
	TaskType    string `name:"TaskType"`
	TaskName    string `name:"TaskName"`
	IspCities   string `name:"IspCities"`
}

// BatchCreateIntantSiteMonitorResponse is the response struct for api BatchCreateIntantSiteMonitor
type BatchCreateIntantSiteMonitorResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	Code      string `json:"Code" xml:"Code"`
}

// CreateBatchCreateIntantSiteMonitorRequest creates a request to invoke BatchCreateIntantSiteMonitor API
func CreateBatchCreateIntantSiteMonitorRequest() (request *BatchCreateIntantSiteMonitorRequest) {
	request = &BatchCreateIntantSiteMonitorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "BatchCreateIntantSiteMonitor", "cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBatchCreateIntantSiteMonitorResponse creates a response to parse from BatchCreateIntantSiteMonitor response
func CreateBatchCreateIntantSiteMonitorResponse() (response *BatchCreateIntantSiteMonitorResponse) {
	response = &BatchCreateIntantSiteMonitorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
