package cr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetRepoList invokes the cr.GetRepoList API synchronously
func (client *Client) GetRepoList(request *GetRepoListRequest) (response *GetRepoListResponse, err error) {
	response = CreateGetRepoListResponse()
	err = client.DoAction(request, response)
	return
}

// GetRepoListWithChan invokes the cr.GetRepoList API asynchronously
func (client *Client) GetRepoListWithChan(request *GetRepoListRequest) (<-chan *GetRepoListResponse, <-chan error) {
	responseChan := make(chan *GetRepoListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetRepoList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetRepoListWithCallback invokes the cr.GetRepoList API asynchronously
func (client *Client) GetRepoListWithCallback(request *GetRepoListRequest, callback func(response *GetRepoListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetRepoListResponse
		var err error
		defer close(result)
		response, err = client.GetRepoList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetRepoListRequest is the request struct for api GetRepoList
type GetRepoListRequest struct {
	*requests.RoaRequest
	PageSize requests.Integer `position:"Query" name:"PageSize"`
	Page     requests.Integer `position:"Query" name:"Page"`
	Status   string           `position:"Query" name:"Status"`
}

// GetRepoListResponse is the response struct for api GetRepoList
type GetRepoListResponse struct {
	*responses.BaseResponse
}

// CreateGetRepoListRequest creates a request to invoke GetRepoList API
func CreateGetRepoListRequest() (request *GetRepoListRequest) {
	request = &GetRepoListRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("cr", "2016-06-07", "GetRepoList", "/repos", "acr", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetRepoListResponse creates a response to parse from GetRepoList response
func CreateGetRepoListResponse() (response *GetRepoListResponse) {
	response = &GetRepoListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
