package cs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeUserQuota invokes the cs.DescribeUserQuota API synchronously
func (client *Client) DescribeUserQuota(request *DescribeUserQuotaRequest) (response *DescribeUserQuotaResponse, err error) {
	response = CreateDescribeUserQuotaResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeUserQuotaWithChan invokes the cs.DescribeUserQuota API asynchronously
func (client *Client) DescribeUserQuotaWithChan(request *DescribeUserQuotaRequest) (<-chan *DescribeUserQuotaResponse, <-chan error) {
	responseChan := make(chan *DescribeUserQuotaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeUserQuota(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeUserQuotaWithCallback invokes the cs.DescribeUserQuota API asynchronously
func (client *Client) DescribeUserQuotaWithCallback(request *DescribeUserQuotaRequest, callback func(response *DescribeUserQuotaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeUserQuotaResponse
		var err error
		defer close(result)
		response, err = client.DescribeUserQuota(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeUserQuotaRequest is the request struct for api DescribeUserQuota
type DescribeUserQuotaRequest struct {
	*requests.RoaRequest
}

// DescribeUserQuotaResponse is the response struct for api DescribeUserQuota
type DescribeUserQuotaResponse struct {
	*responses.BaseResponse
	ClusterNodepoolQuota int64 `json:"cluster_nodepool_quota" xml:"cluster_nodepool_quota"`
	AmkClusterQuota      int64 `json:"amk_cluster_quota" xml:"amk_cluster_quota"`
	ClusterQuota         int64 `json:"cluster_quota" xml:"cluster_quota"`
	NodeQuota            int64 `json:"node_quota" xml:"node_quota"`
	AskClusterQuota      int64 `json:"ask_cluster_quota" xml:"ask_cluster_quota"`
}

// CreateDescribeUserQuotaRequest creates a request to invoke DescribeUserQuota API
func CreateDescribeUserQuotaRequest() (request *DescribeUserQuotaRequest) {
	request = &DescribeUserQuotaRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("CS", "2015-12-15", "DescribeUserQuota", "/quota", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeUserQuotaResponse creates a response to parse from DescribeUserQuota response
func CreateDescribeUserQuotaResponse() (response *DescribeUserQuotaResponse) {
	response = &DescribeUserQuotaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
