package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMongoDBCurrentOp invokes the das.GetMongoDBCurrentOp API synchronously
func (client *Client) GetMongoDBCurrentOp(request *GetMongoDBCurrentOpRequest) (response *GetMongoDBCurrentOpResponse, err error) {
	response = CreateGetMongoDBCurrentOpResponse()
	err = client.DoAction(request, response)
	return
}

// GetMongoDBCurrentOpWithChan invokes the das.GetMongoDBCurrentOp API asynchronously
func (client *Client) GetMongoDBCurrentOpWithChan(request *GetMongoDBCurrentOpRequest) (<-chan *GetMongoDBCurrentOpResponse, <-chan error) {
	responseChan := make(chan *GetMongoDBCurrentOpResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMongoDBCurrentOp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMongoDBCurrentOpWithCallback invokes the das.GetMongoDBCurrentOp API asynchronously
func (client *Client) GetMongoDBCurrentOpWithCallback(request *GetMongoDBCurrentOpRequest, callback func(response *GetMongoDBCurrentOpResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMongoDBCurrentOpResponse
		var err error
		defer close(result)
		response, err = client.GetMongoDBCurrentOp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMongoDBCurrentOpRequest is the request struct for api GetMongoDBCurrentOp
type GetMongoDBCurrentOpRequest struct {
	*requests.RpcRequest
	Role       string `position:"Query" name:"Role"`
	InstanceId string `position:"Query" name:"InstanceId"`
	FilterDoc  string `position:"Query" name:"FilterDoc"`
	NodeId     string `position:"Query" name:"NodeId"`
}

// GetMongoDBCurrentOpResponse is the response struct for api GetMongoDBCurrentOp
type GetMongoDBCurrentOpResponse struct {
	*responses.BaseResponse
}

// CreateGetMongoDBCurrentOpRequest creates a request to invoke GetMongoDBCurrentOp API
func CreateGetMongoDBCurrentOpRequest() (request *GetMongoDBCurrentOpRequest) {
	request = &GetMongoDBCurrentOpRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "GetMongoDBCurrentOp", "", "")
	request.Method = requests.POST
	return
}

// CreateGetMongoDBCurrentOpResponse creates a response to parse from GetMongoDBCurrentOp response
func CreateGetMongoDBCurrentOpResponse() (response *GetMongoDBCurrentOpResponse) {
	response = &GetMongoDBCurrentOpResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
