package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListFileType invokes the dataworks_public.ListFileType API synchronously
func (client *Client) ListFileType(request *ListFileTypeRequest) (response *ListFileTypeResponse, err error) {
	response = CreateListFileTypeResponse()
	err = client.DoAction(request, response)
	return
}

// ListFileTypeWithChan invokes the dataworks_public.ListFileType API asynchronously
func (client *Client) ListFileTypeWithChan(request *ListFileTypeRequest) (<-chan *ListFileTypeResponse, <-chan error) {
	responseChan := make(chan *ListFileTypeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListFileType(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListFileTypeWithCallback invokes the dataworks_public.ListFileType API asynchronously
func (client *Client) ListFileTypeWithCallback(request *ListFileTypeRequest, callback func(response *ListFileTypeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListFileTypeResponse
		var err error
		defer close(result)
		response, err = client.ListFileType(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListFileTypeRequest is the request struct for api ListFileType
type ListFileTypeRequest struct {
	*requests.RpcRequest
	PageSize          requests.Integer `position:"Body" name:"PageSize"`
	Keyword           string           `position:"Body" name:"Keyword"`
	Locale            string           `position:"Body" name:"Locale"`
	ProjectId         requests.Integer `position:"Body" name:"ProjectId"`
	ProjectIdentifier string           `position:"Body" name:"ProjectIdentifier"`
	PageNumber        requests.Integer `position:"Body" name:"PageNumber"`
}

// ListFileTypeResponse is the response struct for api ListFileType
type ListFileTypeResponse struct {
	*responses.BaseResponse
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	NodeTypeInfoList NodeTypeInfoList `json:"NodeTypeInfoList" xml:"NodeTypeInfoList"`
}

// CreateListFileTypeRequest creates a request to invoke ListFileType API
func CreateListFileTypeRequest() (request *ListFileTypeRequest) {
	request = &ListFileTypeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ListFileType", "", "")
	request.Method = requests.POST
	return
}

// CreateListFileTypeResponse creates a response to parse from ListFileType response
func CreateListFileTypeResponse() (response *ListFileTypeResponse) {
	response = &ListFileTypeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
