package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeElasticQps invokes the ddoscoo.DescribeElasticQps API synchronously
func (client *Client) DescribeElasticQps(request *DescribeElasticQpsRequest) (response *DescribeElasticQpsResponse, err error) {
	response = CreateDescribeElasticQpsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeElasticQpsWithChan invokes the ddoscoo.DescribeElasticQps API asynchronously
func (client *Client) DescribeElasticQpsWithChan(request *DescribeElasticQpsRequest) (<-chan *DescribeElasticQpsResponse, <-chan error) {
	responseChan := make(chan *DescribeElasticQpsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeElasticQps(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeElasticQpsWithCallback invokes the ddoscoo.DescribeElasticQps API asynchronously
func (client *Client) DescribeElasticQpsWithCallback(request *DescribeElasticQpsRequest, callback func(response *DescribeElasticQpsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeElasticQpsResponse
		var err error
		defer close(result)
		response, err = client.DescribeElasticQps(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeElasticQpsRequest is the request struct for api DescribeElasticQps
type DescribeElasticQpsRequest struct {
	*requests.RpcRequest
	StartTime requests.Integer `position:"Query" name:"StartTime"`
	SourceIp  string           `position:"Query" name:"SourceIp"`
	Ip        string           `position:"Query" name:"Ip"`
	EndTime   requests.Integer `position:"Query" name:"EndTime"`
	Interval  string           `position:"Query" name:"Interval"`
	Region    string           `position:"Query" name:"Region"`
}

// DescribeElasticQpsResponse is the response struct for api DescribeElasticQps
type DescribeElasticQpsResponse struct {
	*responses.BaseResponse
	RequestId  string           `json:"RequestId" xml:"RequestId"`
	ElasticQps []ElasticQpsItem `json:"ElasticQps" xml:"ElasticQps"`
}

// CreateDescribeElasticQpsRequest creates a request to invoke DescribeElasticQps API
func CreateDescribeElasticQpsRequest() (request *DescribeElasticQpsRequest) {
	request = &DescribeElasticQpsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DescribeElasticQps", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeElasticQpsResponse creates a response to parse from DescribeElasticQps response
func CreateDescribeElasticQpsResponse() (response *DescribeElasticQpsResponse) {
	response = &DescribeElasticQpsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
