package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetTableDesignProjectFlow invokes the dms_enterprise.GetTableDesignProjectFlow API synchronously
func (client *Client) GetTableDesignProjectFlow(request *GetTableDesignProjectFlowRequest) (response *GetTableDesignProjectFlowResponse, err error) {
	response = CreateGetTableDesignProjectFlowResponse()
	err = client.DoAction(request, response)
	return
}

// GetTableDesignProjectFlowWithChan invokes the dms_enterprise.GetTableDesignProjectFlow API asynchronously
func (client *Client) GetTableDesignProjectFlowWithChan(request *GetTableDesignProjectFlowRequest) (<-chan *GetTableDesignProjectFlowResponse, <-chan error) {
	responseChan := make(chan *GetTableDesignProjectFlowResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTableDesignProjectFlow(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTableDesignProjectFlowWithCallback invokes the dms_enterprise.GetTableDesignProjectFlow API asynchronously
func (client *Client) GetTableDesignProjectFlowWithCallback(request *GetTableDesignProjectFlowRequest, callback func(response *GetTableDesignProjectFlowResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTableDesignProjectFlowResponse
		var err error
		defer close(result)
		response, err = client.GetTableDesignProjectFlow(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTableDesignProjectFlowRequest is the request struct for api GetTableDesignProjectFlow
type GetTableDesignProjectFlowRequest struct {
	*requests.RpcRequest
	Tid     requests.Integer `position:"Query" name:"Tid"`
	OrderId requests.Integer `position:"Query" name:"OrderId"`
}

// GetTableDesignProjectFlowResponse is the response struct for api GetTableDesignProjectFlow
type GetTableDesignProjectFlowResponse struct {
	*responses.BaseResponse
	RequestId    string      `json:"RequestId" xml:"RequestId"`
	Success      bool        `json:"Success" xml:"Success"`
	ErrorMessage string      `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode    string      `json:"ErrorCode" xml:"ErrorCode"`
	ProjectFlow  ProjectFlow `json:"ProjectFlow" xml:"ProjectFlow"`
}

// CreateGetTableDesignProjectFlowRequest creates a request to invoke GetTableDesignProjectFlow API
func CreateGetTableDesignProjectFlowRequest() (request *GetTableDesignProjectFlowRequest) {
	request = &GetTableDesignProjectFlowRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "GetTableDesignProjectFlow", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetTableDesignProjectFlowResponse creates a response to parse from GetTableDesignProjectFlow response
func CreateGetTableDesignProjectFlowResponse() (response *GetTableDesignProjectFlowResponse) {
	response = &GetTableDesignProjectFlowResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
