package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListTaskFlow invokes the dms_enterprise.ListTaskFlow API synchronously
func (client *Client) ListTaskFlow(request *ListTaskFlowRequest) (response *ListTaskFlowResponse, err error) {
	response = CreateListTaskFlowResponse()
	err = client.DoAction(request, response)
	return
}

// ListTaskFlowWithChan invokes the dms_enterprise.ListTaskFlow API asynchronously
func (client *Client) ListTaskFlowWithChan(request *ListTaskFlowRequest) (<-chan *ListTaskFlowResponse, <-chan error) {
	responseChan := make(chan *ListTaskFlowResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTaskFlow(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListTaskFlowWithCallback invokes the dms_enterprise.ListTaskFlow API asynchronously
func (client *Client) ListTaskFlowWithCallback(request *ListTaskFlowRequest, callback func(response *ListTaskFlowResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTaskFlowResponse
		var err error
		defer close(result)
		response, err = client.ListTaskFlow(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListTaskFlowRequest is the request struct for api ListTaskFlow
type ListTaskFlowRequest struct {
	*requests.RpcRequest
	Tid requests.Integer `position:"Query" name:"Tid"`
}

// ListTaskFlowResponse is the response struct for api ListTaskFlow
type ListTaskFlowResponse struct {
	*responses.BaseResponse
	RequestId    string                     `json:"RequestId" xml:"RequestId"`
	ErrorCode    string                     `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string                     `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool                       `json:"Success" xml:"Success"`
	TaskFlowList TaskFlowListInListTaskFlow `json:"TaskFlowList" xml:"TaskFlowList"`
}

// CreateListTaskFlowRequest creates a request to invoke ListTaskFlow API
func CreateListTaskFlowRequest() (request *ListTaskFlowRequest) {
	request = &ListTaskFlowRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "ListTaskFlow", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListTaskFlowResponse creates a response to parse from ListTaskFlow response
func CreateListTaskFlowResponse() (response *ListTaskFlowResponse) {
	response = &ListTaskFlowResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
