package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PutStartBackup invokes the drds.PutStartBackup API synchronously
func (client *Client) PutStartBackup(request *PutStartBackupRequest) (response *PutStartBackupResponse, err error) {
	response = CreatePutStartBackupResponse()
	err = client.DoAction(request, response)
	return
}

// PutStartBackupWithChan invokes the drds.PutStartBackup API asynchronously
func (client *Client) PutStartBackupWithChan(request *PutStartBackupRequest) (<-chan *PutStartBackupResponse, <-chan error) {
	responseChan := make(chan *PutStartBackupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PutStartBackup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PutStartBackupWithCallback invokes the drds.PutStartBackup API asynchronously
func (client *Client) PutStartBackupWithCallback(request *PutStartBackupRequest, callback func(response *PutStartBackupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PutStartBackupResponse
		var err error
		defer close(result)
		response, err = client.PutStartBackup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PutStartBackupRequest is the request struct for api PutStartBackup
type PutStartBackupRequest struct {
	*requests.RpcRequest
	BackupDbNames  string `position:"Query" name:"BackupDbNames"`
	BackupLevel    string `position:"Query" name:"BackupLevel"`
	DrdsInstanceId string `position:"Query" name:"DrdsInstanceId"`
	BackupMode     string `position:"Query" name:"BackupMode"`
}

// PutStartBackupResponse is the response struct for api PutStartBackup
type PutStartBackupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    string `json:"Result" xml:"Result"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreatePutStartBackupRequest creates a request to invoke PutStartBackup API
func CreatePutStartBackupRequest() (request *PutStartBackupRequest) {
	request = &PutStartBackupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "PutStartBackup", "drds", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePutStartBackupResponse creates a response to parse from PutStartBackup response
func CreatePutStartBackupResponse() (response *PutStartBackupResponse) {
	response = &PutStartBackupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
