package ebs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLensServiceStatus invokes the ebs.DescribeLensServiceStatus API synchronously
func (client *Client) DescribeLensServiceStatus(request *DescribeLensServiceStatusRequest) (response *DescribeLensServiceStatusResponse, err error) {
	response = CreateDescribeLensServiceStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLensServiceStatusWithChan invokes the ebs.DescribeLensServiceStatus API asynchronously
func (client *Client) DescribeLensServiceStatusWithChan(request *DescribeLensServiceStatusRequest) (<-chan *DescribeLensServiceStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeLensServiceStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLensServiceStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLensServiceStatusWithCallback invokes the ebs.DescribeLensServiceStatus API asynchronously
func (client *Client) DescribeLensServiceStatusWithCallback(request *DescribeLensServiceStatusRequest, callback func(response *DescribeLensServiceStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLensServiceStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeLensServiceStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLensServiceStatusRequest is the request struct for api DescribeLensServiceStatus
type DescribeLensServiceStatusRequest struct {
	*requests.RpcRequest
}

// DescribeLensServiceStatusResponse is the response struct for api DescribeLensServiceStatus
type DescribeLensServiceStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Status    string `json:"Status" xml:"Status"`
}

// CreateDescribeLensServiceStatusRequest creates a request to invoke DescribeLensServiceStatus API
func CreateDescribeLensServiceStatusRequest() (request *DescribeLensServiceStatusRequest) {
	request = &DescribeLensServiceStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ebs", "2021-07-30", "DescribeLensServiceStatus", "ebs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLensServiceStatusResponse creates a response to parse from DescribeLensServiceStatus response
func CreateDescribeLensServiceStatusResponse() (response *DescribeLensServiceStatusResponse) {
	response = &DescribeLensServiceStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
