package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyCapacityReservation invokes the ecs.ModifyCapacityReservation API synchronously
func (client *Client) ModifyCapacityReservation(request *ModifyCapacityReservationRequest) (response *ModifyCapacityReservationResponse, err error) {
	response = CreateModifyCapacityReservationResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyCapacityReservationWithChan invokes the ecs.ModifyCapacityReservation API asynchronously
func (client *Client) ModifyCapacityReservationWithChan(request *ModifyCapacityReservationRequest) (<-chan *ModifyCapacityReservationResponse, <-chan error) {
	responseChan := make(chan *ModifyCapacityReservationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyCapacityReservation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyCapacityReservationWithCallback invokes the ecs.ModifyCapacityReservation API asynchronously
func (client *Client) ModifyCapacityReservationWithCallback(request *ModifyCapacityReservationRequest, callback func(response *ModifyCapacityReservationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyCapacityReservationResponse
		var err error
		defer close(result)
		response, err = client.ModifyCapacityReservation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyCapacityReservationRequest is the request struct for api ModifyCapacityReservation
type ModifyCapacityReservationRequest struct {
	*requests.RpcRequest
	ResourceOwnerId        requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Description            string           `position:"Query" name:"Description"`
	StartTime              string           `position:"Query" name:"StartTime"`
	Platform               string           `position:"Query" name:"Platform"`
	PrivatePoolOptionsId   string           `position:"Query" name:"PrivatePoolOptions.Id"`
	EndTimeType            string           `position:"Query" name:"EndTimeType"`
	ResourceOwnerAccount   string           `position:"Query" name:"ResourceOwnerAccount"`
	PrivatePoolOptionsName string           `position:"Query" name:"PrivatePoolOptions.Name"`
	OwnerAccount           string           `position:"Query" name:"OwnerAccount"`
	EndTime                string           `position:"Query" name:"EndTime"`
	OwnerId                requests.Integer `position:"Query" name:"OwnerId"`
	PackageType            string           `position:"Query" name:"PackageType"`
	InstanceAmount         requests.Integer `position:"Query" name:"InstanceAmount"`
}

// ModifyCapacityReservationResponse is the response struct for api ModifyCapacityReservation
type ModifyCapacityReservationResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyCapacityReservationRequest creates a request to invoke ModifyCapacityReservation API
func CreateModifyCapacityReservationRequest() (request *ModifyCapacityReservationRequest) {
	request = &ModifyCapacityReservationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "ModifyCapacityReservation", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyCapacityReservationResponse creates a response to parse from ModifyCapacityReservation response
func CreateModifyCapacityReservationResponse() (response *ModifyCapacityReservationResponse) {
	response = &ModifyCapacityReservationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
