package ims

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateSAMLProvider invokes the ims.CreateSAMLProvider API synchronously
func (client *Client) CreateSAMLProvider(request *CreateSAMLProviderRequest) (response *CreateSAMLProviderResponse, err error) {
	response = CreateCreateSAMLProviderResponse()
	err = client.DoAction(request, response)
	return
}

// CreateSAMLProviderWithChan invokes the ims.CreateSAMLProvider API asynchronously
func (client *Client) CreateSAMLProviderWithChan(request *CreateSAMLProviderRequest) (<-chan *CreateSAMLProviderResponse, <-chan error) {
	responseChan := make(chan *CreateSAMLProviderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateSAMLProvider(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateSAMLProviderWithCallback invokes the ims.CreateSAMLProvider API asynchronously
func (client *Client) CreateSAMLProviderWithCallback(request *CreateSAMLProviderRequest, callback func(response *CreateSAMLProviderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateSAMLProviderResponse
		var err error
		defer close(result)
		response, err = client.CreateSAMLProvider(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateSAMLProviderRequest is the request struct for api CreateSAMLProvider
type CreateSAMLProviderRequest struct {
	*requests.RpcRequest
	AkProxySuffix               string `position:"Query" name:"AkProxySuffix"`
	Description                 string `position:"Query" name:"Description"`
	SAMLMetadataDocument        string `position:"Query" name:"SAMLMetadataDocument"`
	EncodedSAMLMetadataDocument string `position:"Query" name:"EncodedSAMLMetadataDocument"`
	SAMLProviderName            string `position:"Query" name:"SAMLProviderName"`
}

// CreateSAMLProviderResponse is the response struct for api CreateSAMLProvider
type CreateSAMLProviderResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	SAMLProvider SAMLProvider `json:"SAMLProvider" xml:"SAMLProvider"`
}

// CreateCreateSAMLProviderRequest creates a request to invoke CreateSAMLProvider API
func CreateCreateSAMLProviderRequest() (request *CreateSAMLProviderRequest) {
	request = &CreateSAMLProviderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ims", "2019-08-15", "CreateSAMLProvider", "ims", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateSAMLProviderResponse creates a response to parse from CreateSAMLProvider response
func CreateCreateSAMLProviderResponse() (response *CreateSAMLProviderResponse) {
	response = &CreateSAMLProviderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
