package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetStudioAppTokenOpen invokes the iot.GetStudioAppTokenOpen API synchronously
func (client *Client) GetStudioAppTokenOpen(request *GetStudioAppTokenOpenRequest) (response *GetStudioAppTokenOpenResponse, err error) {
	response = CreateGetStudioAppTokenOpenResponse()
	err = client.DoAction(request, response)
	return
}

// GetStudioAppTokenOpenWithChan invokes the iot.GetStudioAppTokenOpen API asynchronously
func (client *Client) GetStudioAppTokenOpenWithChan(request *GetStudioAppTokenOpenRequest) (<-chan *GetStudioAppTokenOpenResponse, <-chan error) {
	responseChan := make(chan *GetStudioAppTokenOpenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetStudioAppTokenOpen(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetStudioAppTokenOpenWithCallback invokes the iot.GetStudioAppTokenOpen API asynchronously
func (client *Client) GetStudioAppTokenOpenWithCallback(request *GetStudioAppTokenOpenRequest, callback func(response *GetStudioAppTokenOpenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetStudioAppTokenOpenResponse
		var err error
		defer close(result)
		response, err = client.GetStudioAppTokenOpen(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetStudioAppTokenOpenRequest is the request struct for api GetStudioAppTokenOpen
type GetStudioAppTokenOpenRequest struct {
	*requests.RpcRequest
	IotInstanceId string `position:"Body" name:"IotInstanceId"`
	ProjectId     string `position:"Body" name:"ProjectId"`
	AppId         string `position:"Body" name:"AppId"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
}

// GetStudioAppTokenOpenResponse is the response struct for api GetStudioAppTokenOpen
type GetStudioAppTokenOpenResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateGetStudioAppTokenOpenRequest creates a request to invoke GetStudioAppTokenOpen API
func CreateGetStudioAppTokenOpenRequest() (request *GetStudioAppTokenOpenRequest) {
	request = &GetStudioAppTokenOpenRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "GetStudioAppTokenOpen", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetStudioAppTokenOpenResponse creates a response to parse from GetStudioAppTokenOpen response
func CreateGetStudioAppTokenOpenResponse() (response *GetStudioAppTokenOpenResponse) {
	response = &GetStudioAppTokenOpenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
