package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddLiveAppSnapshotConfig invokes the live.AddLiveAppSnapshotConfig API synchronously
func (client *Client) AddLiveAppSnapshotConfig(request *AddLiveAppSnapshotConfigRequest) (response *AddLiveAppSnapshotConfigResponse, err error) {
	response = CreateAddLiveAppSnapshotConfigResponse()
	err = client.DoAction(request, response)
	return
}

// AddLiveAppSnapshotConfigWithChan invokes the live.AddLiveAppSnapshotConfig API asynchronously
func (client *Client) AddLiveAppSnapshotConfigWithChan(request *AddLiveAppSnapshotConfigRequest) (<-chan *AddLiveAppSnapshotConfigResponse, <-chan error) {
	responseChan := make(chan *AddLiveAppSnapshotConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddLiveAppSnapshotConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddLiveAppSnapshotConfigWithCallback invokes the live.AddLiveAppSnapshotConfig API asynchronously
func (client *Client) AddLiveAppSnapshotConfigWithCallback(request *AddLiveAppSnapshotConfigRequest, callback func(response *AddLiveAppSnapshotConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddLiveAppSnapshotConfigResponse
		var err error
		defer close(result)
		response, err = client.AddLiveAppSnapshotConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddLiveAppSnapshotConfigRequest is the request struct for api AddLiveAppSnapshotConfig
type AddLiveAppSnapshotConfigRequest struct {
	*requests.RpcRequest
	TimeInterval       requests.Integer `position:"Query" name:"TimeInterval"`
	OssEndpoint        string           `position:"Query" name:"OssEndpoint"`
	AppName            string           `position:"Query" name:"AppName"`
	SecurityToken      string           `position:"Query" name:"SecurityToken"`
	OverwriteOssObject string           `position:"Query" name:"OverwriteOssObject"`
	OssBucket          string           `position:"Query" name:"OssBucket"`
	DomainName         string           `position:"Query" name:"DomainName"`
	SequenceOssObject  string           `position:"Query" name:"SequenceOssObject"`
	OwnerId            requests.Integer `position:"Query" name:"OwnerId"`
	Callback           string           `position:"Query" name:"Callback"`
}

// AddLiveAppSnapshotConfigResponse is the response struct for api AddLiveAppSnapshotConfig
type AddLiveAppSnapshotConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddLiveAppSnapshotConfigRequest creates a request to invoke AddLiveAppSnapshotConfig API
func CreateAddLiveAppSnapshotConfigRequest() (request *AddLiveAppSnapshotConfigRequest) {
	request = &AddLiveAppSnapshotConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "AddLiveAppSnapshotConfig", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddLiveAppSnapshotConfigResponse creates a response to parse from AddLiveAppSnapshotConfig response
func CreateAddLiveAppSnapshotConfigResponse() (response *AddLiveAppSnapshotConfigResponse) {
	response = &AddLiveAppSnapshotConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
