package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeShowList invokes the live.DescribeShowList API synchronously
func (client *Client) DescribeShowList(request *DescribeShowListRequest) (response *DescribeShowListResponse, err error) {
	response = CreateDescribeShowListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeShowListWithChan invokes the live.DescribeShowList API asynchronously
func (client *Client) DescribeShowListWithChan(request *DescribeShowListRequest) (<-chan *DescribeShowListResponse, <-chan error) {
	responseChan := make(chan *DescribeShowListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeShowList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeShowListWithCallback invokes the live.DescribeShowList API asynchronously
func (client *Client) DescribeShowListWithCallback(request *DescribeShowListRequest, callback func(response *DescribeShowListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeShowListResponse
		var err error
		defer close(result)
		response, err = client.DescribeShowList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeShowListRequest is the request struct for api DescribeShowList
type DescribeShowListRequest struct {
	*requests.RpcRequest
	CasterId string           `position:"Query" name:"CasterId"`
	OwnerId  requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeShowListResponse is the response struct for api DescribeShowList
type DescribeShowListResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	ShowList     string       `json:"ShowList" xml:"ShowList"`
	ShowListInfo ShowListInfo `json:"ShowListInfo" xml:"ShowListInfo"`
}

// CreateDescribeShowListRequest creates a request to invoke DescribeShowList API
func CreateDescribeShowListRequest() (request *DescribeShowListRequest) {
	request = &DescribeShowListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeShowList", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeShowListResponse creates a response to parse from DescribeShowList response
func CreateDescribeShowListResponse() (response *DescribeShowListResponse) {
	response = &DescribeShowListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
