package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListLiveMessageGroupByPage invokes the live.ListLiveMessageGroupByPage API synchronously
func (client *Client) ListLiveMessageGroupByPage(request *ListLiveMessageGroupByPageRequest) (response *ListLiveMessageGroupByPageResponse, err error) {
	response = CreateListLiveMessageGroupByPageResponse()
	err = client.DoAction(request, response)
	return
}

// ListLiveMessageGroupByPageWithChan invokes the live.ListLiveMessageGroupByPage API asynchronously
func (client *Client) ListLiveMessageGroupByPageWithChan(request *ListLiveMessageGroupByPageRequest) (<-chan *ListLiveMessageGroupByPageResponse, <-chan error) {
	responseChan := make(chan *ListLiveMessageGroupByPageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListLiveMessageGroupByPage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListLiveMessageGroupByPageWithCallback invokes the live.ListLiveMessageGroupByPage API asynchronously
func (client *Client) ListLiveMessageGroupByPageWithCallback(request *ListLiveMessageGroupByPageRequest, callback func(response *ListLiveMessageGroupByPageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListLiveMessageGroupByPageResponse
		var err error
		defer close(result)
		response, err = client.ListLiveMessageGroupByPage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListLiveMessageGroupByPageRequest is the request struct for api ListLiveMessageGroupByPage
type ListLiveMessageGroupByPageRequest struct {
	*requests.RpcRequest
	SortType    requests.Integer `position:"Query" name:"SortType"`
	GroupStatus requests.Integer `position:"Query" name:"GroupStatus"`
	DataCenter  string           `position:"Query" name:"DataCenter"`
	PageNumber  requests.Integer `position:"Query" name:"PageNumber"`
	AppId       string           `position:"Query" name:"AppId"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
}

// ListLiveMessageGroupByPageResponse is the response struct for api ListLiveMessageGroupByPage
type ListLiveMessageGroupByPageResponse struct {
	*responses.BaseResponse
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	TotalCount int      `json:"TotalCount" xml:"TotalCount"`
	PageNumber int      `json:"PageNumber" xml:"PageNumber"`
	PageSize   int      `json:"PageSize" xml:"PageSize"`
	GroupList  []Groups `json:"GroupList" xml:"GroupList"`
}

// CreateListLiveMessageGroupByPageRequest creates a request to invoke ListLiveMessageGroupByPage API
func CreateListLiveMessageGroupByPageRequest() (request *ListLiveMessageGroupByPageRequest) {
	request = &ListLiveMessageGroupByPageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "ListLiveMessageGroupByPage", "live", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListLiveMessageGroupByPageResponse creates a response to parse from ListLiveMessageGroupByPage response
func CreateListLiveMessageGroupByPageResponse() (response *ListLiveMessageGroupByPageResponse) {
	response = &ListLiveMessageGroupByPageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
