package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateEventSub invokes the live.UpdateEventSub API synchronously
func (client *Client) UpdateEventSub(request *UpdateEventSubRequest) (response *UpdateEventSubResponse, err error) {
	response = CreateUpdateEventSubResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateEventSubWithChan invokes the live.UpdateEventSub API asynchronously
func (client *Client) UpdateEventSubWithChan(request *UpdateEventSubRequest) (<-chan *UpdateEventSubResponse, <-chan error) {
	responseChan := make(chan *UpdateEventSubResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateEventSub(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateEventSubWithCallback invokes the live.UpdateEventSub API asynchronously
func (client *Client) UpdateEventSubWithCallback(request *UpdateEventSubRequest, callback func(response *UpdateEventSubResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateEventSubResponse
		var err error
		defer close(result)
		response, err = client.UpdateEventSub(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateEventSubRequest is the request struct for api UpdateEventSub
type UpdateEventSubRequest struct {
	*requests.RpcRequest
	SubscribeId string    `position:"Query" name:"SubscribeId"`
	Users       *[]string `position:"Query" name:"Users"  type:"Repeated"`
	AppId       string    `position:"Query" name:"AppId"`
	CallbackUrl string    `position:"Query" name:"CallbackUrl"`
	ChannelId   string    `position:"Query" name:"ChannelId"`
	Events      *[]string `position:"Query" name:"Events"  type:"Repeated"`
}

// UpdateEventSubResponse is the response struct for api UpdateEventSub
type UpdateEventSubResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateEventSubRequest creates a request to invoke UpdateEventSub API
func CreateUpdateEventSubRequest() (request *UpdateEventSubRequest) {
	request = &UpdateEventSubRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "UpdateEventSub", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateEventSubResponse creates a response to parse from UpdateEventSub response
func CreateUpdateEventSubResponse() (response *UpdateEventSubResponse) {
	response = &UpdateEventSubResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
