package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryNamespace invokes the mse.QueryNamespace API synchronously
func (client *Client) QueryNamespace(request *QueryNamespaceRequest) (response *QueryNamespaceResponse, err error) {
	response = CreateQueryNamespaceResponse()
	err = client.DoAction(request, response)
	return
}

// QueryNamespaceWithChan invokes the mse.QueryNamespace API asynchronously
func (client *Client) QueryNamespaceWithChan(request *QueryNamespaceRequest) (<-chan *QueryNamespaceResponse, <-chan error) {
	responseChan := make(chan *QueryNamespaceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryNamespace(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryNamespaceWithCallback invokes the mse.QueryNamespace API asynchronously
func (client *Client) QueryNamespaceWithCallback(request *QueryNamespaceRequest, callback func(response *QueryNamespaceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryNamespaceResponse
		var err error
		defer close(result)
		response, err = client.QueryNamespace(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryNamespaceRequest is the request struct for api QueryNamespace
type QueryNamespaceRequest struct {
	*requests.RpcRequest
	MseSessionId   string `position:"Query" name:"MseSessionId"`
	Name           string `position:"Query" name:"Name"`
	AcceptLanguage string `position:"Query" name:"AcceptLanguage"`
	Region         string `position:"Query" name:"Region"`
}

// QueryNamespaceResponse is the response struct for api QueryNamespace
type QueryNamespaceResponse struct {
	*responses.BaseResponse
	HttpStatusCode int             `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string          `json:"Message" xml:"Message"`
	RequestId      string          `json:"RequestId" xml:"RequestId"`
	ErrorCode      string          `json:"ErrorCode" xml:"ErrorCode"`
	Success        bool            `json:"Success" xml:"Success"`
	Data           []NamespaceList `json:"Data" xml:"Data"`
}

// CreateQueryNamespaceRequest creates a request to invoke QueryNamespace API
func CreateQueryNamespaceRequest() (request *QueryNamespaceRequest) {
	request = &QueryNamespaceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "QueryNamespace", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryNamespaceResponse creates a response to parse from QueryNamespace response
func CreateQueryNamespaceResponse() (response *QueryNamespaceResponse) {
	response = &QueryNamespaceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
