package oos

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteParameter invokes the oos.DeleteParameter API synchronously
func (client *Client) DeleteParameter(request *DeleteParameterRequest) (response *DeleteParameterResponse, err error) {
	response = CreateDeleteParameterResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteParameterWithChan invokes the oos.DeleteParameter API asynchronously
func (client *Client) DeleteParameterWithChan(request *DeleteParameterRequest) (<-chan *DeleteParameterResponse, <-chan error) {
	responseChan := make(chan *DeleteParameterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteParameter(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteParameterWithCallback invokes the oos.DeleteParameter API asynchronously
func (client *Client) DeleteParameterWithCallback(request *DeleteParameterRequest, callback func(response *DeleteParameterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteParameterResponse
		var err error
		defer close(result)
		response, err = client.DeleteParameter(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteParameterRequest is the request struct for api DeleteParameter
type DeleteParameterRequest struct {
	*requests.RpcRequest
	Name string `position:"Query" name:"Name"`
}

// DeleteParameterResponse is the response struct for api DeleteParameter
type DeleteParameterResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteParameterRequest creates a request to invoke DeleteParameter API
func CreateDeleteParameterRequest() (request *DeleteParameterRequest) {
	request = &DeleteParameterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("oos", "2019-06-01", "DeleteParameter", "oos", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteParameterResponse creates a response to parse from DeleteParameter response
func CreateDeleteParameterResponse() (response *DeleteParameterResponse) {
	response = &DeleteParameterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
