package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateUserAnalyzer invokes the opensearch.CreateUserAnalyzer API synchronously
func (client *Client) CreateUserAnalyzer(request *CreateUserAnalyzerRequest) (response *CreateUserAnalyzerResponse, err error) {
	response = CreateCreateUserAnalyzerResponse()
	err = client.DoAction(request, response)
	return
}

// CreateUserAnalyzerWithChan invokes the opensearch.CreateUserAnalyzer API asynchronously
func (client *Client) CreateUserAnalyzerWithChan(request *CreateUserAnalyzerRequest) (<-chan *CreateUserAnalyzerResponse, <-chan error) {
	responseChan := make(chan *CreateUserAnalyzerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateUserAnalyzer(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateUserAnalyzerWithCallback invokes the opensearch.CreateUserAnalyzer API asynchronously
func (client *Client) CreateUserAnalyzerWithCallback(request *CreateUserAnalyzerRequest, callback func(response *CreateUserAnalyzerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateUserAnalyzerResponse
		var err error
		defer close(result)
		response, err = client.CreateUserAnalyzer(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateUserAnalyzerRequest is the request struct for api CreateUserAnalyzer
type CreateUserAnalyzerRequest struct {
	*requests.RoaRequest
}

// CreateUserAnalyzerResponse is the response struct for api CreateUserAnalyzer
type CreateUserAnalyzerResponse struct {
	*responses.BaseResponse
	Result    map[string]interface{} `json:"result" xml:"result"`
	RequestId string                 `json:"RequestId" xml:"RequestId"`
}

// CreateCreateUserAnalyzerRequest creates a request to invoke CreateUserAnalyzer API
func CreateCreateUserAnalyzerRequest() (request *CreateUserAnalyzerRequest) {
	request = &CreateUserAnalyzerRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "CreateUserAnalyzer", "/v4/openapi/user-analyzers", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateUserAnalyzerResponse creates a response to parse from CreateUserAnalyzer response
func CreateCreateUserAnalyzerResponse() (response *CreateUserAnalyzerResponse) {
	response = &CreateUserAnalyzerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
