package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListScriptRecording invokes the outboundbot.ListScriptRecording API synchronously
func (client *Client) ListScriptRecording(request *ListScriptRecordingRequest) (response *ListScriptRecordingResponse, err error) {
	response = CreateListScriptRecordingResponse()
	err = client.DoAction(request, response)
	return
}

// ListScriptRecordingWithChan invokes the outboundbot.ListScriptRecording API asynchronously
func (client *Client) ListScriptRecordingWithChan(request *ListScriptRecordingRequest) (<-chan *ListScriptRecordingResponse, <-chan error) {
	responseChan := make(chan *ListScriptRecordingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListScriptRecording(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListScriptRecordingWithCallback invokes the outboundbot.ListScriptRecording API asynchronously
func (client *Client) ListScriptRecordingWithCallback(request *ListScriptRecordingRequest, callback func(response *ListScriptRecordingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListScriptRecordingResponse
		var err error
		defer close(result)
		response, err = client.ListScriptRecording(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListScriptRecordingRequest is the request struct for api ListScriptRecording
type ListScriptRecordingRequest struct {
	*requests.RpcRequest
	UuidsJson  string           `position:"Query" name:"UuidsJson"`
	StatesJson string           `position:"Query" name:"StatesJson"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	ScriptId   string           `position:"Query" name:"ScriptId"`
	Search     string           `position:"Query" name:"Search"`
	InstanceId string           `position:"Query" name:"InstanceId"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
}

// ListScriptRecordingResponse is the response struct for api ListScriptRecording
type ListScriptRecordingResponse struct {
	*responses.BaseResponse
	HttpStatusCode   int               `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId        string            `json:"RequestId" xml:"RequestId"`
	Success          bool              `json:"Success" xml:"Success"`
	Code             string            `json:"Code" xml:"Code"`
	Message          string            `json:"Message" xml:"Message"`
	PageSize         int               `json:"PageSize" xml:"PageSize"`
	PageNumber       int               `json:"PageNumber" xml:"PageNumber"`
	TotalCount       int64             `json:"TotalCount" xml:"TotalCount"`
	ScriptRecordings []ScriptRecording `json:"ScriptRecordings" xml:"ScriptRecordings"`
}

// CreateListScriptRecordingRequest creates a request to invoke ListScriptRecording API
func CreateListScriptRecordingRequest() (request *ListScriptRecordingRequest) {
	request = &ListScriptRecordingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "ListScriptRecording", "", "")
	request.Method = requests.POST
	return
}

// CreateListScriptRecordingResponse creates a response to parse from ListScriptRecording response
func CreateListScriptRecordingResponse() (response *ListScriptRecordingResponse) {
	response = &ListScriptRecordingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
