package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CloneEngineConfig invokes the pairecservice.CloneEngineConfig API synchronously
func (client *Client) CloneEngineConfig(request *CloneEngineConfigRequest) (response *CloneEngineConfigResponse, err error) {
	response = CreateCloneEngineConfigResponse()
	err = client.DoAction(request, response)
	return
}

// CloneEngineConfigWithChan invokes the pairecservice.CloneEngineConfig API asynchronously
func (client *Client) CloneEngineConfigWithChan(request *CloneEngineConfigRequest) (<-chan *CloneEngineConfigResponse, <-chan error) {
	responseChan := make(chan *CloneEngineConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CloneEngineConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CloneEngineConfigWithCallback invokes the pairecservice.CloneEngineConfig API asynchronously
func (client *Client) CloneEngineConfigWithCallback(request *CloneEngineConfigRequest, callback func(response *CloneEngineConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CloneEngineConfigResponse
		var err error
		defer close(result)
		response, err = client.CloneEngineConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CloneEngineConfigRequest is the request struct for api CloneEngineConfig
type CloneEngineConfigRequest struct {
	*requests.RoaRequest
	EngineConfigId string `position:"Path" name:"EngineConfigId"`
	Body           string `position:"Body" name:"body"`
}

// CloneEngineConfigResponse is the response struct for api CloneEngineConfig
type CloneEngineConfigResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	EngineConfigId string `json:"EngineConfigId" xml:"EngineConfigId"`
}

// CreateCloneEngineConfigRequest creates a request to invoke CloneEngineConfig API
func CreateCloneEngineConfigRequest() (request *CloneEngineConfigRequest) {
	request = &CloneEngineConfigRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "CloneEngineConfig", "/api/v1/engineconfigs/[EngineConfigId]/action/clone", "", "")
	request.Method = requests.POST
	return
}

// CreateCloneEngineConfigResponse creates a response to parse from CloneEngineConfig response
func CreateCloneEngineConfigResponse() (response *CloneEngineConfigResponse) {
	response = &CloneEngineConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
