package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateColdStorageInstance invokes the polardb.CreateColdStorageInstance API synchronously
func (client *Client) CreateColdStorageInstance(request *CreateColdStorageInstanceRequest) (response *CreateColdStorageInstanceResponse, err error) {
	response = CreateCreateColdStorageInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateColdStorageInstanceWithChan invokes the polardb.CreateColdStorageInstance API asynchronously
func (client *Client) CreateColdStorageInstanceWithChan(request *CreateColdStorageInstanceRequest) (<-chan *CreateColdStorageInstanceResponse, <-chan error) {
	responseChan := make(chan *CreateColdStorageInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateColdStorageInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateColdStorageInstanceWithCallback invokes the polardb.CreateColdStorageInstance API asynchronously
func (client *Client) CreateColdStorageInstanceWithCallback(request *CreateColdStorageInstanceRequest, callback func(response *CreateColdStorageInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateColdStorageInstanceResponse
		var err error
		defer close(result)
		response, err = client.CreateColdStorageInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateColdStorageInstanceRequest is the request struct for api CreateColdStorageInstance
type CreateColdStorageInstanceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId                requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken                    string           `position:"Query" name:"ClientToken"`
	ResourceGroupId                string           `position:"Query" name:"ResourceGroupId"`
	ResourceOwnerAccount           string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId                    string           `position:"Query" name:"DBClusterId"`
	OwnerAccount                   string           `position:"Query" name:"OwnerAccount"`
	ColdStorageInstanceDescription string           `position:"Query" name:"ColdStorageInstanceDescription"`
	OwnerId                        requests.Integer `position:"Query" name:"OwnerId"`
}

// CreateColdStorageInstanceResponse is the response struct for api CreateColdStorageInstance
type CreateColdStorageInstanceResponse struct {
	*responses.BaseResponse
	RequestId             string `json:"RequestId" xml:"RequestId"`
	ColdStorageInstanceId string `json:"ColdStorageInstanceId" xml:"ColdStorageInstanceId"`
}

// CreateCreateColdStorageInstanceRequest creates a request to invoke CreateColdStorageInstance API
func CreateCreateColdStorageInstanceRequest() (request *CreateColdStorageInstanceRequest) {
	request = &CreateColdStorageInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "CreateColdStorageInstance", "polardb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateColdStorageInstanceResponse creates a response to parse from CreateColdStorageInstance response
func CreateCreateColdStorageInstanceResponse() (response *CreateColdStorageInstanceResponse) {
	response = &CreateColdStorageInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
