package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TestRuleV4 invokes the qualitycheck.TestRuleV4 API synchronously
func (client *Client) TestRuleV4(request *TestRuleV4Request) (response *TestRuleV4Response, err error) {
	response = CreateTestRuleV4Response()
	err = client.DoAction(request, response)
	return
}

// TestRuleV4WithChan invokes the qualitycheck.TestRuleV4 API asynchronously
func (client *Client) TestRuleV4WithChan(request *TestRuleV4Request) (<-chan *TestRuleV4Response, <-chan error) {
	responseChan := make(chan *TestRuleV4Response, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TestRuleV4(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TestRuleV4WithCallback invokes the qualitycheck.TestRuleV4 API asynchronously
func (client *Client) TestRuleV4WithCallback(request *TestRuleV4Request, callback func(response *TestRuleV4Response, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TestRuleV4Response
		var err error
		defer close(result)
		response, err = client.TestRuleV4(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TestRuleV4Request is the request struct for api TestRuleV4
type TestRuleV4Request struct {
	*requests.RpcRequest
	IsSchemeData requests.Integer `position:"Body" name:"IsSchemeData"`
	TestJson     string           `position:"Body" name:"TestJson"`
}

// TestRuleV4Response is the response struct for api TestRuleV4
type TestRuleV4Response struct {
	*responses.BaseResponse
}

// CreateTestRuleV4Request creates a request to invoke TestRuleV4 API
func CreateTestRuleV4Request() (request *TestRuleV4Request) {
	request = &TestRuleV4Request{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "TestRuleV4", "", "")
	request.Method = requests.POST
	return
}

// CreateTestRuleV4Response creates a response to parse from TestRuleV4 response
func CreateTestRuleV4Response() (response *TestRuleV4Response) {
	response = &TestRuleV4Response{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
