package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateOrderForDeleteDBNodes invokes the rds.CreateOrderForDeleteDBNodes API synchronously
func (client *Client) CreateOrderForDeleteDBNodes(request *CreateOrderForDeleteDBNodesRequest) (response *CreateOrderForDeleteDBNodesResponse, err error) {
	response = CreateCreateOrderForDeleteDBNodesResponse()
	err = client.DoAction(request, response)
	return
}

// CreateOrderForDeleteDBNodesWithChan invokes the rds.CreateOrderForDeleteDBNodes API asynchronously
func (client *Client) CreateOrderForDeleteDBNodesWithChan(request *CreateOrderForDeleteDBNodesRequest) (<-chan *CreateOrderForDeleteDBNodesResponse, <-chan error) {
	responseChan := make(chan *CreateOrderForDeleteDBNodesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateOrderForDeleteDBNodes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateOrderForDeleteDBNodesWithCallback invokes the rds.CreateOrderForDeleteDBNodes API asynchronously
func (client *Client) CreateOrderForDeleteDBNodesWithCallback(request *CreateOrderForDeleteDBNodesRequest, callback func(response *CreateOrderForDeleteDBNodesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateOrderForDeleteDBNodesResponse
		var err error
		defer close(result)
		response, err = client.CreateOrderForDeleteDBNodes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateOrderForDeleteDBNodesRequest is the request struct for api CreateOrderForDeleteDBNodes
type CreateOrderForDeleteDBNodesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	NodeType             string           `position:"Query" name:"NodeType"`
	DBNodeId             string           `position:"Query" name:"DBNodeId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	EngineVersion        string           `position:"Query" name:"EngineVersion"`
	ResourceGroupId      string           `position:"Query" name:"ResourceGroupId"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
	BusinessInfo         string           `position:"Query" name:"BusinessInfo"`
	AutoPay              requests.Boolean `position:"Query" name:"AutoPay"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	Resource             string           `position:"Query" name:"Resource"`
	CommodityCode        string           `position:"Query" name:"CommodityCode"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PromotionCode        string           `position:"Query" name:"PromotionCode"`
	ZoneId               string           `position:"Query" name:"ZoneId"`
}

// CreateOrderForDeleteDBNodesResponse is the response struct for api CreateOrderForDeleteDBNodes
type CreateOrderForDeleteDBNodesResponse struct {
	*responses.BaseResponse
	DBInstanceId string `json:"DBInstanceId" xml:"DBInstanceId"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	OrderId      int64  `json:"OrderId" xml:"OrderId"`
}

// CreateCreateOrderForDeleteDBNodesRequest creates a request to invoke CreateOrderForDeleteDBNodes API
func CreateCreateOrderForDeleteDBNodesRequest() (request *CreateOrderForDeleteDBNodesRequest) {
	request = &CreateOrderForDeleteDBNodesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "CreateOrderForDeleteDBNodes", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateOrderForDeleteDBNodesResponse creates a response to parse from CreateOrderForDeleteDBNodes response
func CreateCreateOrderForDeleteDBNodesResponse() (response *CreateOrderForDeleteDBNodesResponse) {
	response = &CreateOrderForDeleteDBNodesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
