package resourcemanager

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CancelCreateCloudAccount invokes the resourcemanager.CancelCreateCloudAccount API synchronously
func (client *Client) CancelCreateCloudAccount(request *CancelCreateCloudAccountRequest) (response *CancelCreateCloudAccountResponse, err error) {
	response = CreateCancelCreateCloudAccountResponse()
	err = client.DoAction(request, response)
	return
}

// CancelCreateCloudAccountWithChan invokes the resourcemanager.CancelCreateCloudAccount API asynchronously
func (client *Client) CancelCreateCloudAccountWithChan(request *CancelCreateCloudAccountRequest) (<-chan *CancelCreateCloudAccountResponse, <-chan error) {
	responseChan := make(chan *CancelCreateCloudAccountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CancelCreateCloudAccount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CancelCreateCloudAccountWithCallback invokes the resourcemanager.CancelCreateCloudAccount API asynchronously
func (client *Client) CancelCreateCloudAccountWithCallback(request *CancelCreateCloudAccountRequest, callback func(response *CancelCreateCloudAccountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CancelCreateCloudAccountResponse
		var err error
		defer close(result)
		response, err = client.CancelCreateCloudAccount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CancelCreateCloudAccountRequest is the request struct for api CancelCreateCloudAccount
type CancelCreateCloudAccountRequest struct {
	*requests.RpcRequest
	RecordId string `position:"Query" name:"RecordId"`
}

// CancelCreateCloudAccountResponse is the response struct for api CancelCreateCloudAccount
type CancelCreateCloudAccountResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCancelCreateCloudAccountRequest creates a request to invoke CancelCreateCloudAccount API
func CreateCancelCreateCloudAccountRequest() (request *CancelCreateCloudAccountRequest) {
	request = &CancelCreateCloudAccountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceManager", "2020-03-31", "CancelCreateCloudAccount", "resourcemanager", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCancelCreateCloudAccountResponse creates a response to parse from CancelCreateCloudAccount response
func CreateCancelCreateCloudAccountResponse() (response *CancelCreateCloudAccountResponse) {
	response = &CancelCreateCloudAccountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
