package retailadvqa_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetTokenPayLoadByCheck invokes the retailadvqa_public.GetTokenPayLoadByCheck API synchronously
func (client *Client) GetTokenPayLoadByCheck(request *GetTokenPayLoadByCheckRequest) (response *GetTokenPayLoadByCheckResponse, err error) {
	response = CreateGetTokenPayLoadByCheckResponse()
	err = client.DoAction(request, response)
	return
}

// GetTokenPayLoadByCheckWithChan invokes the retailadvqa_public.GetTokenPayLoadByCheck API asynchronously
func (client *Client) GetTokenPayLoadByCheckWithChan(request *GetTokenPayLoadByCheckRequest) (<-chan *GetTokenPayLoadByCheckResponse, <-chan error) {
	responseChan := make(chan *GetTokenPayLoadByCheckResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTokenPayLoadByCheck(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTokenPayLoadByCheckWithCallback invokes the retailadvqa_public.GetTokenPayLoadByCheck API asynchronously
func (client *Client) GetTokenPayLoadByCheckWithCallback(request *GetTokenPayLoadByCheckRequest, callback func(response *GetTokenPayLoadByCheckResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTokenPayLoadByCheckResponse
		var err error
		defer close(result)
		response, err = client.GetTokenPayLoadByCheck(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTokenPayLoadByCheckRequest is the request struct for api GetTokenPayLoadByCheck
type GetTokenPayLoadByCheckRequest struct {
	*requests.RpcRequest
	AccessId   string `position:"Query" name:"AccessId"`
	SignNonce  string `position:"Body" name:"SignNonce"`
	SignDriver string `position:"Body" name:"SignDriver"`
	TenantId   string `position:"Query" name:"TenantId"`
	SignToken  string `position:"Body" name:"SignToken"`
	SignPk     string `position:"Body" name:"SignPk"`
}

// GetTokenPayLoadByCheckResponse is the response struct for api GetTokenPayLoadByCheck
type GetTokenPayLoadByCheckResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorDesc string `json:"ErrorDesc" xml:"ErrorDesc"`
	Success   bool   `json:"Success" xml:"Success"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetTokenPayLoadByCheckRequest creates a request to invoke GetTokenPayLoadByCheck API
func CreateGetTokenPayLoadByCheckRequest() (request *GetTokenPayLoadByCheckRequest) {
	request = &GetTokenPayLoadByCheckRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailadvqa-public", "2020-05-15", "GetTokenPayLoadByCheck", "", "")
	request.Method = requests.POST
	return
}

// CreateGetTokenPayLoadByCheckResponse creates a response to parse from GetTokenPayLoadByCheck response
func CreateGetTokenPayLoadByCheckResponse() (response *GetTokenPayLoadByCheckResponse) {
	response = &GetTokenPayLoadByCheckResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
