package schedulerx3

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListScheduleTimes invokes the schedulerx3.ListScheduleTimes API synchronously
func (client *Client) ListScheduleTimes(request *ListScheduleTimesRequest) (response *ListScheduleTimesResponse, err error) {
	response = CreateListScheduleTimesResponse()
	err = client.DoAction(request, response)
	return
}

// ListScheduleTimesWithChan invokes the schedulerx3.ListScheduleTimes API asynchronously
func (client *Client) ListScheduleTimesWithChan(request *ListScheduleTimesRequest) (<-chan *ListScheduleTimesResponse, <-chan error) {
	responseChan := make(chan *ListScheduleTimesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListScheduleTimes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListScheduleTimesWithCallback invokes the schedulerx3.ListScheduleTimes API asynchronously
func (client *Client) ListScheduleTimesWithCallback(request *ListScheduleTimesRequest, callback func(response *ListScheduleTimesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListScheduleTimesResponse
		var err error
		defer close(result)
		response, err = client.ListScheduleTimes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListScheduleTimesRequest is the request struct for api ListScheduleTimes
type ListScheduleTimesRequest struct {
	*requests.RpcRequest
	MseSessionId   string           `position:"Query" name:"MseSessionId"`
	TimeZone       string           `position:"Query" name:"TimeZone"`
	AppName        string           `position:"Query" name:"AppName"`
	Calendar       string           `position:"Query" name:"Calendar"`
	ClusterId      string           `position:"Query" name:"ClusterId"`
	TimeExpression string           `position:"Query" name:"TimeExpression"`
	TimeType       requests.Integer `position:"Query" name:"TimeType"`
}

// ListScheduleTimesResponse is the response struct for api ListScheduleTimes
type ListScheduleTimesResponse struct {
	*responses.BaseResponse
	Code      int      `json:"Code" xml:"Code"`
	Message   string   `json:"Message" xml:"Message"`
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Success   bool     `json:"Success" xml:"Success"`
	Data      []string `json:"Data" xml:"Data"`
}

// CreateListScheduleTimesRequest creates a request to invoke ListScheduleTimes API
func CreateListScheduleTimesRequest() (request *ListScheduleTimesRequest) {
	request = &ListScheduleTimesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SchedulerX3", "2024-06-24", "ListScheduleTimes", "", "")
	request.Method = requests.GET
	return
}

// CreateListScheduleTimesResponse creates a response to parse from ListScheduleTimes response
func CreateListScheduleTimesResponse() (response *ListScheduleTimesResponse) {
	response = &ListScheduleTimesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
