package slb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeHighDefinationMonitor invokes the slb.DescribeHighDefinationMonitor API synchronously
func (client *Client) DescribeHighDefinationMonitor(request *DescribeHighDefinationMonitorRequest) (response *DescribeHighDefinationMonitorResponse, err error) {
	response = CreateDescribeHighDefinationMonitorResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeHighDefinationMonitorWithChan invokes the slb.DescribeHighDefinationMonitor API asynchronously
func (client *Client) DescribeHighDefinationMonitorWithChan(request *DescribeHighDefinationMonitorRequest) (<-chan *DescribeHighDefinationMonitorResponse, <-chan error) {
	responseChan := make(chan *DescribeHighDefinationMonitorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeHighDefinationMonitor(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeHighDefinationMonitorWithCallback invokes the slb.DescribeHighDefinationMonitor API asynchronously
func (client *Client) DescribeHighDefinationMonitorWithCallback(request *DescribeHighDefinationMonitorRequest, callback func(response *DescribeHighDefinationMonitorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeHighDefinationMonitorResponse
		var err error
		defer close(result)
		response, err = client.DescribeHighDefinationMonitor(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeHighDefinationMonitorRequest is the request struct for api DescribeHighDefinationMonitor
type DescribeHighDefinationMonitorRequest struct {
	*requests.RpcRequest
	AccessKeyId          string           `position:"Query" name:"access_key_id"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Tags                 string           `position:"Query" name:"Tags"`
}

// DescribeHighDefinationMonitorResponse is the response struct for api DescribeHighDefinationMonitor
type DescribeHighDefinationMonitorResponse struct {
	*responses.BaseResponse
	LogProject string `json:"LogProject" xml:"LogProject"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	LogStore   string `json:"LogStore" xml:"LogStore"`
	Success    string `json:"Success" xml:"Success"`
}

// CreateDescribeHighDefinationMonitorRequest creates a request to invoke DescribeHighDefinationMonitor API
func CreateDescribeHighDefinationMonitorRequest() (request *DescribeHighDefinationMonitorRequest) {
	request = &DescribeHighDefinationMonitorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Slb", "2014-05-15", "DescribeHighDefinationMonitor", "slb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeHighDefinationMonitorResponse creates a response to parse from DescribeHighDefinationMonitor response
func CreateDescribeHighDefinationMonitorResponse() (response *DescribeHighDefinationMonitorResponse) {
	response = &DescribeHighDefinationMonitorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
