package tag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisablePolicyType invokes the tag.DisablePolicyType API synchronously
func (client *Client) DisablePolicyType(request *DisablePolicyTypeRequest) (response *DisablePolicyTypeResponse, err error) {
	response = CreateDisablePolicyTypeResponse()
	err = client.DoAction(request, response)
	return
}

// DisablePolicyTypeWithChan invokes the tag.DisablePolicyType API asynchronously
func (client *Client) DisablePolicyTypeWithChan(request *DisablePolicyTypeRequest) (<-chan *DisablePolicyTypeResponse, <-chan error) {
	responseChan := make(chan *DisablePolicyTypeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisablePolicyType(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisablePolicyTypeWithCallback invokes the tag.DisablePolicyType API asynchronously
func (client *Client) DisablePolicyTypeWithCallback(request *DisablePolicyTypeRequest, callback func(response *DisablePolicyTypeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisablePolicyTypeResponse
		var err error
		defer close(result)
		response, err = client.DisablePolicyType(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisablePolicyTypeRequest is the request struct for api DisablePolicyType
type DisablePolicyTypeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      string           `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	UserType             string           `position:"Query" name:"UserType"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	OpenType             string           `position:"Query" name:"OpenType"`
}

// DisablePolicyTypeResponse is the response struct for api DisablePolicyType
type DisablePolicyTypeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDisablePolicyTypeRequest creates a request to invoke DisablePolicyType API
func CreateDisablePolicyTypeRequest() (request *DisablePolicyTypeRequest) {
	request = &DisablePolicyTypeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Tag", "2018-08-28", "DisablePolicyType", "tag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDisablePolicyTypeResponse creates a response to parse from DisablePolicyType response
func CreateDisablePolicyTypeResponse() (response *DisablePolicyTypeResponse) {
	response = &DisablePolicyTypeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
