package adb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ApplyAdviceById invokes the adb.ApplyAdviceById API synchronously
func (client *Client) ApplyAdviceById(request *ApplyAdviceByIdRequest) (response *ApplyAdviceByIdResponse, err error) {
	response = CreateApplyAdviceByIdResponse()
	err = client.DoAction(request, response)
	return
}

// ApplyAdviceByIdWithChan invokes the adb.ApplyAdviceById API asynchronously
func (client *Client) ApplyAdviceByIdWithChan(request *ApplyAdviceByIdRequest) (<-chan *ApplyAdviceByIdResponse, <-chan error) {
	responseChan := make(chan *ApplyAdviceByIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ApplyAdviceById(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ApplyAdviceByIdWithCallback invokes the adb.ApplyAdviceById API asynchronously
func (client *Client) ApplyAdviceByIdWithCallback(request *ApplyAdviceByIdRequest, callback func(response *ApplyAdviceByIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ApplyAdviceByIdResponse
		var err error
		defer close(result)
		response, err = client.ApplyAdviceById(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ApplyAdviceByIdRequest is the request struct for api ApplyAdviceById
type ApplyAdviceByIdRequest struct {
	*requests.RpcRequest
	AdviceId    string           `position:"Query" name:"AdviceId"`
	DBClusterId string           `position:"Query" name:"DBClusterId"`
	AdviceDate  requests.Integer `position:"Query" name:"AdviceDate"`
}

// ApplyAdviceByIdResponse is the response struct for api ApplyAdviceById
type ApplyAdviceByIdResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateApplyAdviceByIdRequest creates a request to invoke ApplyAdviceById API
func CreateApplyAdviceByIdRequest() (request *ApplyAdviceByIdRequest) {
	request = &ApplyAdviceByIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("adb", "2019-03-15", "ApplyAdviceById", "ads", "openAPI")
	request.Method = requests.POST
	return
}

// CreateApplyAdviceByIdResponse creates a response to parse from ApplyAdviceById response
func CreateApplyAdviceByIdResponse() (response *ApplyAdviceByIdResponse) {
	response = &ApplyAdviceByIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
